/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.configuration.editor;

import com.schneide.base.configuration.editor.PropertyEditor;
import com.schneide.base.layout.StringGridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public abstract class FilesystemPropertyEditor
extends PropertyEditor
implements ActionListener {
    private static final long serialVersionUID = -2443922787330665091L;
    private final JTextField valueField;
    private final JPanel componentPanel;
    private FileFilter fileFilter;

    public FilesystemPropertyEditor(String key, File oldFileElement, boolean onlyDirectories) {
        super(key);
        this.valueField = new JTextField(oldFileElement.getPath());
        JButton browseButton = new JButton("...");
        browseButton.addActionListener(this);
        this.componentPanel = new JPanel(new StringGridBagLayout());
        this.componentPanel.add("gridx=0, gridy=0, gridwidth=1, gridheight=1, anchor=CENTER, fill=HORIZONTAL, insets=[2,2,2,2]", this.valueField);
        this.componentPanel.add("gridx=1, gridy=0, gridwidth=1, gridheight=1, anchor=WEST, fill=HORIZONTAL, insets=[2,2,2,2]", browseButton);
        if (onlyDirectories) {
            this.fileFilter = new FileFilter(this){

                @Override
                public boolean accept(File arg0) {
                    return arg0.isDirectory();
                }

                @Override
                public String getDescription() {
                    return "nur Verzeichnisse";
                }
            };
        }
    }

    @Override
    public JComponent getEditorComponent() {
        return this.componentPanel;
    }

    @Override
    public String getValue() {
        return this.valueField.getText();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        File targetFile;
        File sourceDirectory = targetFile = new File(this.getValue());
        if (!targetFile.isDirectory()) {
            sourceDirectory = targetFile.getParentFile();
        }
        JFileChooser fileChooser = new JFileChooser(sourceDirectory);
        if (this.fileFilter != null) {
            fileChooser.setAcceptAllFileFilterUsed(false);
            fileChooser.setFileFilter(this.fileFilter);
        }
        fileChooser.setSelectedFile(targetFile);
        int answer = fileChooser.showDialog(this, "Ausw\u00e4hlen");
        if (answer == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            this.valueField.setText(selectedFile.getPath());
        }
    }
}

