/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.configuration.editor;

import com.schneide.base.configuration.editor.PropertyEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;

public class BooleanPropertyEditor
extends PropertyEditor {
    private static final long serialVersionUID = 5095807950967511187L;
    private final JComboBox<BooleanChoice> comboBox;

    public BooleanPropertyEditor(String key, boolean oldValue) {
        super(key);
        BooleanChoice[] choices = new BooleanChoice[]{new BooleanChoice("true", "ja"), new BooleanChoice("false", "nein")};
        this.comboBox = new JComboBox<BooleanChoice>(choices);
        if (!oldValue) {
            this.comboBox.setSelectedIndex(1);
        }
    }

    @Override
    public JComponent getEditorComponent() {
        return this.comboBox;
    }

    @Override
    public String getValue() {
        return ((BooleanChoice)this.comboBox.getSelectedItem()).getValue();
    }

    private static class BooleanChoice {
        private final String value;
        private final String denotation;

        public BooleanChoice(String value, String denotation) {
            this.value = value;
            this.denotation = denotation;
        }

        public String getDenotation() {
            return this.denotation;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.getDenotation();
        }
    }
}

