/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.configuration;

import com.schneide.base.configuration.ConfigurationException;
import com.schneide.base.configuration.parsers.BooleanPropertyParser;
import com.schneide.base.configuration.parsers.DirectoryPropertyParser;
import com.schneide.base.configuration.parsers.DoublePropertyParser;
import com.schneide.base.configuration.parsers.FilePropertyParser;
import com.schneide.base.configuration.parsers.IntegerPropertyParser;
import com.schneide.base.configuration.parsers.LongPropertyParser;
import com.schneide.base.configuration.parsers.PropertyParser;
import com.schneide.base.configuration.parsers.QuantityPropertyParser;
import com.schneide.base.configuration.parsers.StringPropertyParser;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.text.TextBuffer;
import com.schneide.base.util.Parameter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;

public abstract class ParsedProperties
extends LoggedObject {
    public static final StringPropertyParser PARSER_STRING = new StringPropertyParser();
    public static final BooleanPropertyParser PARSER_BOOLEAN = new BooleanPropertyParser();
    public static final IntegerPropertyParser PARSER_INTEGER = new IntegerPropertyParser();
    public static final LongPropertyParser PARSER_LONG = new LongPropertyParser();
    public static final DoublePropertyParser PARSER_DOUBLE = new DoublePropertyParser();
    public static final FilePropertyParser PARSER_FILE = new FilePropertyParser();
    public static final DirectoryPropertyParser PARSER_DIRECTORY = new DirectoryPropertyParser();
    public static final QuantityPropertyParser PARSER_QUANTITY = new QuantityPropertyParser();
    private static final Map<String, ParsedProperties> PROPERTIES_INSTANCES = new HashMap<String, ParsedProperties>();
    private final String identifier;
    private Properties properties;

    public static PropertyParser[] getPropertyParsers() {
        return new PropertyParser[]{PARSER_QUANTITY, PARSER_BOOLEAN, PARSER_DOUBLE, PARSER_DIRECTORY, PARSER_FILE, PARSER_INTEGER, PARSER_LONG, PARSER_STRING};
    }

    protected ParsedProperties(String identifier) {
        this.identifier = identifier;
        if (PROPERTIES_INSTANCES.containsKey(identifier)) {
            this.getLogger().warn("Ein Eigenschaftenobjekt mit der Identit\u00e4t '" + identifier + "' ist bereits registriert.", new Throwable());
        }
        PROPERTIES_INSTANCES.put(identifier, this);
        this.properties = new Properties();
    }

    public static ParsedProperties getProperties(String identifiers) throws NoSuchElementException {
        if (null != identifiers && PROPERTIES_INSTANCES.containsKey(identifiers)) {
            return PROPERTIES_INSTANCES.get(identifiers);
        }
        throw new NoSuchElementException("Kein Eigenschaftenobjekt mit der Identit\u00e4t '" + identifiers + "' gefunden.");
    }

    public boolean containsProperty(String propertyName) {
        return this.properties.containsKey(propertyName);
    }

    protected void loadPropertiesFrom(Reader input) throws IOException {
        this.properties.load(input);
    }

    protected void storePropertiesTo(Writer output) throws IOException {
        this.storePropertiesTo(output, "// Diese Datei wurde maschinengeschrieben.");
    }

    protected void storePropertiesTo(Writer output, String headerComment) throws IOException {
        this.properties.store(output, headerComment);
    }

    public synchronized String[] getPropertyKeys() {
        Set<Object> keySet = this.properties.keySet();
        Object[] preResult = keySet.toArray(new Object[keySet.size()]);
        String[] result = new String[preResult.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = String.valueOf(preResult[i]);
        }
        return result;
    }

    public String getPropertyValue(String propertyKey) {
        return this.properties.getProperty(propertyKey);
    }

    public void setPropertyEntry(String key, String value) {
        if (this.properties.containsKey(key)) {
            this.properties.setProperty(key, value);
            this.notifyWrite(key);
        }
    }

    public static synchronized String[] getIdentifiers() {
        String[] result = new String[PROPERTIES_INSTANCES.size()];
        int index = 0;
        Iterator<String> iter = PROPERTIES_INSTANCES.keySet().iterator();
        while (iter.hasNext()) {
            result[index] = iter.next();
            ++index;
        }
        return result;
    }

    public int getSize() {
        return this.properties.size();
    }

    protected void createNewProperties() {
        this.setNewProperties(new Properties());
    }

    protected void setNewProperties(Properties newProperties) {
        this.properties = newProperties;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    protected void notifyRead(String propertyName) {
        Parameter.isPresent(propertyName);
    }

    protected void notifyWrite(String propertyName) {
        Parameter.isPresent(propertyName);
    }

    protected int parseIntegerProperty(String propertyName) throws ConfigurationException {
        int result = PARSER_INTEGER.parse(propertyName, this.getPropertyValue(propertyName));
        this.notifyRead(propertyName);
        return result;
    }

    protected long parseLongProperty(String propertyName) throws ConfigurationException {
        long result = PARSER_LONG.parse(propertyName, this.getPropertyValue(propertyName));
        this.notifyRead(propertyName);
        return result;
    }

    protected String parseStringProperty(String propertyName) throws NoSuchElementException {
        String result = PARSER_STRING.parse(propertyName, this.getPropertyValue(propertyName));
        this.notifyRead(propertyName);
        return result;
    }

    protected double parseDoubleProperty(String propertyName) throws NoSuchElementException {
        double result = PARSER_DOUBLE.parse(propertyName, this.getPropertyValue(propertyName));
        this.notifyRead(propertyName);
        return result;
    }

    protected boolean parseBooleanProperty(String propertyName) throws NoSuchElementException {
        boolean result = PARSER_BOOLEAN.parse(propertyName, this.getPropertyValue(propertyName));
        this.notifyRead(propertyName);
        return result;
    }

    protected File parseDirectoryProperty(String propertyName) throws NoSuchElementException {
        File result = PARSER_DIRECTORY.parse(propertyName, this.getPropertyValue(propertyName));
        this.notifyRead(propertyName);
        return result;
    }

    protected File parseFileProperty(String propertyName) throws NoSuchElementException {
        File result = PARSER_FILE.parse(propertyName, this.getPropertyValue(propertyName));
        this.notifyRead(propertyName);
        return result;
    }

    protected void setIntegerProperty(String propertyName, int value) {
        this.properties.setProperty(propertyName, String.valueOf(value));
        this.notifyWrite(propertyName);
    }

    protected void setLongProperty(String propertyName, long value) {
        this.properties.setProperty(propertyName, String.valueOf(value));
        this.notifyWrite(propertyName);
    }

    protected void setDoubleProperty(String propertyName, double value) {
        this.properties.setProperty(propertyName, String.valueOf(value));
        this.notifyWrite(propertyName);
    }

    protected void setStringProperty(String propertyName, String value) {
        this.properties.setProperty(propertyName, value);
        this.notifyWrite(propertyName);
    }

    protected void setBooleanProperty(String propertyName, boolean value) {
        this.properties.setProperty(propertyName, this.getBooleanRepresentation(value));
        this.notifyWrite(propertyName);
    }

    private String getBooleanRepresentation(boolean value) {
        if (value) {
            return "true";
        }
        return "false";
    }

    protected void setDirectoryProperty(String propertyName, File directory) {
        this.properties.setProperty(propertyName, directory.getPath());
        this.notifyWrite(propertyName);
    }

    protected void setFileProperty(String propertyName, File file) {
        this.properties.setProperty(propertyName, file.getPath());
        this.notifyWrite(propertyName);
    }

    public String toString() {
        TextBuffer result = new TextBuffer();
        result.append("Properties '");
        result.append(this.getIdentifier());
        result.addln("':");
        result.addln("-------------------------------");
        StringWriter buffer = new StringWriter();
        try {
            this.storePropertiesTo(buffer);
            result.append(buffer.toString());
        }
        catch (IOException e) {
            result.append("IOException occurred when printing out the content.");
        }
        result.addln("-------------------------------");
        return result.toString();
    }
}

