/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.module;

import com.schneide.base.application.module.AdditionalParameters;
import com.schneide.base.application.module.ApplicationModule;
import com.schneide.base.application.module.ModuleBuilder;
import com.schneide.base.application.module.ModuleEnvironment;
import com.schneide.base.application.module.ModuleException;
import com.schneide.base.application.module.ModuleFactory;
import com.schneide.base.application.module.ModuleMode;
import com.schneide.base.application.module.ModuleTypeSpecification;
import com.schneide.base.application.module.icon.ModuleIconSupplier;
import com.schneide.base.gui.icon.IconProvider;
import com.schneide.base.gui.swing.EDT;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.text.transformation.Embrace;
import java.awt.Dialog;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.swing.JFrame;

public abstract class AbstractModuleFactory<M extends ApplicationModule<M>>
extends LoggedObject
implements ModuleFactory<M> {
    private final ModuleTypeSpecification moduleSpecification;
    private final Map<String, ModuleBuilder<M>> builderMap;
    private final ModuleIconSupplier moduleIcon;
    private final ModuleEnvironment environment;

    public AbstractModuleFactory(ModuleTypeSpecification module, ModuleIconSupplier moduleIcon, ModuleEnvironment environment) {
        this.moduleSpecification = module;
        this.moduleIcon = moduleIcon;
        this.environment = environment;
        this.builderMap = new HashMap<String, ModuleBuilder<M>>();
    }

    @Override
    public M buildModule(String instanceIdentifier, String instanceDenotation, ModuleMode mode, VirtualFile configurationFile, AdditionalParameters additionalParameters) throws NoSuchElementException, ModuleException {
        if (!this.hasBuilderFor(mode.getIdentifier())) {
            throw new NoSuchElementException("Keine Modulfabrik f\u00fcr Typ '" + String.valueOf(mode) + "' gefunden.");
        }
        ModuleBuilder<M> builder = this.getBuilderFor(mode.getIdentifier());
        this.getLogger().info("Baue Modul " + this.getModuleSpecification().getDenotation() + Embrace.withSquareBrackets(instanceDenotation) + " im Typmodus " + builder.getMode().getDenotation());
        return builder.buildModuleFor(this, instanceIdentifier, instanceDenotation, (IconProvider)this.moduleIcon().apply(instanceIdentifier), configurationFile, this.environment.applicationBus(), this.environment.capabilities(), additionalParameters);
    }

    protected ModuleBuilder<M> getBuilderFor(String mode) {
        return this.builderMap.get(mode);
    }

    @Override
    public ModuleIconSupplier moduleIcon() {
        return this.moduleIcon;
    }

    protected boolean hasBuilderFor(String mode) {
        return this.builderMap.containsKey(mode);
    }

    protected void addBuilder(ModuleBuilder<M> builder) {
        if (null == builder) {
            return;
        }
        if (this.hasCorrectModuleDependency(this.moduleSpecification)) {
            this.builderMap.put(builder.getMode().getIdentifier(), builder);
            builder.modeSynonyms().forEach(synonym -> this.builderMap.put((String)synonym, builder));
        }
    }

    private boolean hasCorrectModuleDependency(ModuleTypeSpecification module) {
        return module.equals(this.getModuleSpecification());
    }

    @Override
    public ModuleMode getModeFor(String modeIdentifier) throws NoSuchElementException {
        if (!this.hasBuilderFor(modeIdentifier)) {
            throw new NoSuchElementException("Module factory does not support mode " + modeIdentifier);
        }
        return this.getBuilderFor(modeIdentifier).getMode();
    }

    @Override
    public final Iterable<ModuleMode> getAvailableModes() {
        HashSet<ModuleMode> result = new HashSet<ModuleMode>();
        for (ModuleBuilder<M> moduleBuilder : this.builderMap.values()) {
            result.add(moduleBuilder.getMode());
        }
        return result;
    }

    @Override
    public final ModuleTypeSpecification getModuleSpecification() {
        return this.moduleSpecification;
    }

    @Override
    public JFrame newFrame() {
        return EDT.query(() -> {
            JFrame result = new JFrame();
            result.setIconImage(this.environment.applicationIcon().icon().getImage());
            result.setModalExclusionType(Dialog.ModalExclusionType.TOOLKIT_EXCLUDE);
            return result;
        });
    }
}

