/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.module;

import com.schneide.base.application.module.AdditionalParameters;
import com.schneide.base.application.module.ApplicationModule;
import com.schneide.base.application.module.ModuleBuildInformation;
import com.schneide.base.application.module.ModuleBuilder;
import com.schneide.base.application.module.ModuleException;
import com.schneide.base.application.module.ModuleFactory;
import com.schneide.base.application.module.ModuleMode;
import com.schneide.base.application.module.ModuleTypeSpecification;
import com.schneide.base.application.module.generic.GenericModuleBuildInformation;
import com.schneide.base.application.module.generic.GenericModuleMode;
import com.schneide.base.application.module.generic.GenericModuleSpecification;
import com.schneide.base.application.module.icon.ModuleIconSupplier;
import com.schneide.base.capability.CapabilityStorage;
import com.schneide.base.eventbus.EventBus;
import com.schneide.base.gui.icon.IconProvider;
import com.schneide.base.i18n.model.I18NResolvable;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.properties.userLevel.SuffixProvider;

public abstract class AbstractModuleBuilder<M extends ApplicationModule<M>>
extends LoggedObject
implements ModuleBuilder<M> {
    private final ModuleMode mode;
    private final ModuleTypeSpecification module;

    public AbstractModuleBuilder(ModuleTypeSpecification module, String type, I18NResolvable key, ModuleIconSupplier modeIcon) {
        this(module, type, key.resolvedText(), modeIcon);
    }

    public AbstractModuleBuilder(ModuleTypeSpecification module, String type, String denotation, ModuleIconSupplier modeIcon) {
        this(module, new GenericModuleMode(type, denotation, modeIcon));
    }

    public AbstractModuleBuilder(ModuleTypeSpecification module, ModuleMode mode) {
        this.module = module;
        this.mode = mode;
    }

    @Override
    public final ModuleMode getMode() {
        return this.mode;
    }

    @Override
    public final M buildModuleFor(ModuleFactory<M> factory, String identifier, String denotation, IconProvider icon, VirtualFile configurationFile, EventBus eventBus, CapabilityStorage capabilities, AdditionalParameters parameters) throws ModuleException {
        GenericModuleSpecification specification = new GenericModuleSpecification(identifier, denotation, icon, this.getMode(), this.module);
        GenericModuleBuildInformation<M> buildInformation = new GenericModuleBuildInformation<M>(specification, factory, capabilities, this.editionFrom(parameters));
        return this.buildSpecificModule(buildInformation, configurationFile, eventBus, parameters);
    }

    protected abstract SuffixProvider editionFrom(AdditionalParameters var1);

    protected abstract M buildSpecificModule(ModuleBuildInformation<M> var1, VirtualFile var2, EventBus var3, AdditionalParameters var4) throws ModuleException;
}

