/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application;

import com.schneide.base.gui.GenericWindowStack;
import com.schneide.base.gui.model.WindowStack;
import com.schneide.base.logging.LoggedObject;
import java.awt.Frame;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class AbstractSession
extends LoggedObject {
    private final String identifier;
    private final String denotation;
    private final Map<String, GenericWindowStack> windowStacks;
    private Frame sessionMainFrame;

    public AbstractSession(String identifier) {
        this(identifier, "");
    }

    public AbstractSession(String identifier, String denotation) {
        this.identifier = identifier;
        this.denotation = denotation;
        this.windowStacks = new HashMap<String, GenericWindowStack>();
        this.createNewWindowStack(identifier, new Window[0]);
    }

    public final String getDenotation() {
        return this.denotation;
    }

    public Iterable<WindowStack> getWindowStacks() {
        return new ArrayList<WindowStack>(this.windowStacks.values());
    }

    public GenericWindowStack getMainWindowStack() {
        return this.getWindowStack(this.identifier);
    }

    public GenericWindowStack getWindowStack(String stackIdentifier) {
        return this.windowStacks.get(stackIdentifier);
    }

    public boolean hasWindowStack(String stackIdentifier) {
        return this.windowStacks.containsKey(stackIdentifier);
    }

    public WindowStack createNewWindowStack(String stackIdentifier, Window ... initialContent) {
        if (!this.hasWindowStack(stackIdentifier)) {
            GenericWindowStack newStack = new GenericWindowStack(stackIdentifier, new Window[0]);
            for (Window window : initialContent) {
                newStack.getWindowStack().push(window);
            }
            this.windowStacks.put(stackIdentifier, newStack);
        }
        return this.getWindowStack(stackIdentifier);
    }

    public void removeWindowStack(WindowStack stack) {
        this.windowStacks.remove(stack.getIdentifier());
    }

    protected void setMainFrame(Frame frame) {
        this.sessionMainFrame = frame;
    }

    protected Frame getMainFrame() {
        return this.sessionMainFrame;
    }

    public boolean hasMainFrame() {
        return null != this.getMainFrame();
    }

    public boolean isMainFrame(Window window) {
        return this.hasMainFrame() && this.getMainFrame().equals(window);
    }
}

