/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.module.datenimport.excel.model.format;

import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.werp.module.datenimport.excel.model.ExcelAlsMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dhatim.fastexcel.reader.Cell;
import org.dhatim.fastexcel.reader.ReadableWorkbook;
import org.dhatim.fastexcel.reader.Sheet;

public class XlsxAlsMap
implements ExcelAlsMap {
    @Override
    public String nameDesErstenArbeitsblattesAus(VirtualFile exceldatei) throws IOException {
        return this.onWorkbook(exceldatei, workbook -> workbook.getFirstSheet().getName());
    }

    @Override
    public Map<Integer, List<String>> erstesArbeitsblattAus(VirtualFile exceldatei) throws IOException {
        return this.onWorkbook(exceldatei, workbook -> this.sheetToMap(workbook.getFirstSheet()));
    }

    @Override
    public Map<String, Map<Integer, List<String>>> alleArbeitsbl\u00e4tterAus(VirtualFile exceldatei) throws IOException {
        return this.onWorkbook(exceldatei, workbook -> {
            HashMap<String, Map<Integer, List<String>>> result = new HashMap<String, Map<Integer, List<String>>>();
            List allSheets = workbook.getSheets().collect(Collectors.toList());
            for (Sheet each : allSheets) {
                Map<Integer, List<String>> sheetContent = this.sheetToMap(each);
                result.put(each.getName(), sheetContent);
            }
            return result;
        });
    }

    @Override
    public Map<Integer, List<String>> spezifischesArbeitsblattAus(VirtualFile exceldatei, String arbeitsblattname) throws IOException {
        return this.onWorkbook(exceldatei, workbook -> this.sheetToMap((Sheet)workbook.findSheet(arbeitsblattname).orElseThrow(() -> new IOException("Kann Arbeitsblatt mit Namen " + arbeitsblattname + " nicht finden."))));
    }

    protected <RESULT> RESULT onWorkbook(VirtualFile exceldatei, WorkbookConverter<RESULT> converter) throws IOException {
        try (InputStream input = exceldatei.getInputStream();){
            RESULT RESULT;
            try (ReadableWorkbook workbook = new ReadableWorkbook(input);){
                RESULT = converter.convert(workbook);
            }
            return RESULT;
        }
    }

    protected Map<Integer, List<String>> sheetToMap(Sheet sheet) throws IOException {
        HashMap<Integer, List<String>> result = new HashMap<Integer, List<String>>();
        try (Stream rows = sheet.openStream();){
            rows.forEach(r -> {
                ArrayList<String> cellContent = new ArrayList<String>();
                for (Cell cell : r) {
                    if (cell == null) {
                        cellContent.add("");
                        continue;
                    }
                    String rawValue = cell.getRawValue();
                    if (rawValue == null) {
                        cellContent.add("");
                        continue;
                    }
                    cellContent.add(cell.getRawValue());
                }
                if (!cellContent.isEmpty()) {
                    result.put(r.getRowNum(), cellContent);
                }
            });
        }
        return result;
    }

    @FunctionalInterface
    protected static interface WorkbookConverter<RESULT> {
        public RESULT convert(ReadableWorkbook var1) throws IOException;
    }
}

