/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.module.datenimport.excel.model.format;

import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.werp.module.datenimport.excel.model.ExcelAlsMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.read.biff.BiffException;

public class XlsAlsMap
implements ExcelAlsMap {
    @Override
    public String nameDesErstenArbeitsblattesAus(VirtualFile exceldatei) throws IOException {
        return this.onWorkbook(exceldatei, workbook -> workbook.getSheet(0).getName());
    }

    @Override
    public Map<Integer, List<String>> erstesArbeitsblattAus(VirtualFile exceldatei) throws IOException {
        return this.onWorkbook(exceldatei, workbook -> this.sheetToMap(workbook.getSheet(0)));
    }

    @Override
    public Map<String, Map<Integer, List<String>>> alleArbeitsbl\u00e4tterAus(VirtualFile exceldatei) throws IOException {
        return this.onWorkbook(exceldatei, workbook -> {
            HashMap<String, Map<Integer, List<String>>> result = new HashMap<String, Map<Integer, List<String>>>();
            for (Sheet each : workbook.getSheets()) {
                Map<Integer, List<String>> sheetContent = this.sheetToMap(each);
                result.put(each.getName(), sheetContent);
            }
            return result;
        });
    }

    @Override
    public Map<Integer, List<String>> spezifischesArbeitsblattAus(VirtualFile exceldatei, String arbeitsblattname) throws IOException {
        return this.onWorkbook(exceldatei, workbook -> {
            Sheet sheetForName = Optional.ofNullable(workbook.getSheet(arbeitsblattname)).orElseThrow(() -> new IOException("Kann Arbeitsblatt mit Namen " + arbeitsblattname + " nicht finden."));
            return this.sheetToMap(sheetForName);
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <RESULT> RESULT onWorkbook(VirtualFile exceldatei, WorkbookConverter<RESULT> converter) throws IOException {
        WorkbookSettings settings = new WorkbookSettings();
        settings.setEncoding("ISO-8859-15");
        try (InputStream input = exceldatei.getInputStream();){
            Workbook workbook = Workbook.getWorkbook((InputStream)input, (WorkbookSettings)settings);
            RESULT RESULT = converter.convert(workbook);
            return RESULT;
        }
        catch (BiffException e) {
            throw new IOException(e);
        }
    }

    protected Map<Integer, List<String>> sheetToMap(Sheet sheet) {
        HashMap<Integer, List<String>> result = new HashMap<Integer, List<String>>();
        for (int row = 0; row < sheet.getRows(); ++row) {
            result.put(row, new ArrayList());
            for (int column = 0; column < sheet.getColumns(); ++column) {
                ((List)result.get(row)).add(sheet.getCell(column, row).getContents());
            }
        }
        return result;
    }

    @FunctionalInterface
    protected static interface WorkbookConverter<RESULT> {
        public RESULT convert(Workbook var1) throws IOException;
    }
}

