/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.periphery.datenimport.model;

import com.schneide.werp.domain.format.excel.Exceldatei;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class GeladeneExceldatei
implements Exceldatei {
    private final Map<String, Map<Integer, List<String>>> tabellen;
    private final String dateiname;
    private final String ersteTabelle;
    private final int kopfzeilen;

    public GeladeneExceldatei(String dateiname, Map<String, Map<Integer, List<String>>> tabellen, String ersteTabelle, int kopfzeilen) {
        this.dateiname = dateiname;
        this.tabellen = tabellen;
        this.ersteTabelle = ersteTabelle;
        this.kopfzeilen = kopfzeilen;
    }

    public String name() {
        return this.dateiname;
    }

    public Exceldatei mitKopfzeilen(int zeilen) {
        return new GeladeneExceldatei(this.dateiname, this.tabellen, this.ersteTabelle, zeilen);
    }

    public Iterable<String> alleTabellennamen() {
        return this.tabellen.keySet();
    }

    public Iterable<Exceldatei.Exceltabelle> alleTabellen() {
        ArrayList<Exceldatei.Exceltabelle> result = new ArrayList<Exceldatei.Exceltabelle>();
        this.tabellen.forEach((name, daten) -> {
            GeladeneExceltabelle tabelle = new GeladeneExceltabelle((String)name, this.kopfzeilen, (Map<Integer, List<String>>)daten);
            result.add(tabelle);
        });
        return result;
    }

    public Exceldatei.Exceltabelle ersteTabelle() {
        return this.alsTabelle(this.ersteTabelle);
    }

    public Optional<Exceldatei.Exceltabelle> tabelleF\u00fcr(String name) {
        if (!this.tabellen.containsKey(name)) {
            return Optional.empty();
        }
        return Optional.of(this.alsTabelle(name));
    }

    protected GeladeneExceltabelle alsTabelle(String tabellenname) {
        return new GeladeneExceltabelle(tabellenname, this.kopfzeilen, this.tabellen.get(tabellenname));
    }

    public static class GeladeneExceltabelle
    implements Exceldatei.Exceltabelle {
        private final String name;
        private final Map<Integer, List<String>> daten;
        private final int kopfzeilen;
        private final Exceldatei.Tabellengr\u00f6\u00dfe gr\u00f6\u00dfe;

        public GeladeneExceltabelle(String name, int kopfzeilen, Map<Integer, List<String>> daten) {
            this.name = name;
            this.kopfzeilen = kopfzeilen;
            this.daten = daten;
            int maximaleZeile = this.daten.keySet().stream().mapToInt(Integer::intValue).max().orElse(0);
            int maximaleSpalte = this.daten.values().stream().mapToInt(List::size).max().orElse(0);
            this.gr\u00f6\u00dfe = new Exceldatei.Tabellengr\u00f6\u00dfe(maximaleZeile, maximaleSpalte);
        }

        public String name() {
            return this.name;
        }

        public Exceldatei.Tabellengr\u00f6\u00dfe gr\u00f6\u00dfe() {
            return this.gr\u00f6\u00dfe;
        }

        public Iterable<Exceldatei.Excelzeile> zeilenNachKopfzeilen() {
            Optional<Exceldatei.Excelzeile> neueZeile;
            ArrayList<Exceldatei.Excelzeile> result = new ArrayList<Exceldatei.Excelzeile>();
            boolean found = false;
            do {
                int cursor = result.size() + 1;
                neueZeile = this.zeile(cursor);
                neueZeile.ifPresent(result::add);
            } while (found = neueZeile.isPresent());
            return result;
        }

        public Optional<Exceldatei.Excelzeile> zeile(int nachKopfzeilen) {
            int zeilenindex = this.kopfzeilen + nachKopfzeilen;
            if (zeilenindex > this.gr\u00f6\u00dfe.zeilen()) {
                return Optional.empty();
            }
            return Optional.of(new GeladeneExcelzeile(this.name(), String.valueOf(zeilenindex), Optional.ofNullable(this.daten.get(zeilenindex)).orElseGet(Collections::emptyList)));
        }

        public Optional<String> zellentext(Exceldatei.Zellenkoordinate koordinate) {
            return this.zeile(koordinate.zeile()).map(ez -> ez.stringIn(koordinate.spalte()));
        }
    }

    public static class GeladeneExcelzeile
    implements Exceldatei.Excelzeile {
        private final List<String> spalten;
        private final String name;
        private final String tabellenname;

        public GeladeneExcelzeile(String tabellenname, String name, List<String> spalten) {
            this.tabellenname = tabellenname;
            this.name = name;
            this.spalten = spalten;
        }

        public String tabellenname() {
            return this.tabellenname;
        }

        public String name() {
            return this.name;
        }

        public String stringIn(int spalte) {
            if (this.spalten.size() <= spalte) {
                return "";
            }
            return this.spalten.get(spalte);
        }

        public int spalten() {
            return this.spalten.size();
        }
    }
}

