/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.periphery.datenimport.lader.standard;

import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.logging.LoggedObject;
import com.schneide.werp.domain.format.csv.CSVDatei;
import com.schneide.werp.periphery.datenimport.lader.CSVLader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Scanner;

public class DateibasierterCSVLader
extends LoggedObject
implements CSVLader {
    private final String separator;

    public DateibasierterCSVLader() {
        this(";");
    }

    public DateibasierterCSVLader(String separator) {
        this.separator = separator;
    }

    @Override
    public CSVDatei ladenAus(final VirtualFile datei) throws IOException {
        final ArrayList<1> result = new ArrayList<1>();
        try (Scanner einlesen = new Scanner(datei.getReader());){
            while (einlesen.hasNextLine()) {
                String zeile = einlesen.nextLine().trim();
                final String[] teile = zeile.split(this.separator);
                CSVDatei.CSVZeile ergebnis = new CSVDatei.CSVZeile(){

                    public Optional<String> stringIn(int spalte) {
                        if (spalte < 0 || spalte >= teile.length) {
                            return Optional.empty();
                        }
                        return Optional.of(teile[spalte].trim());
                    }
                };
                result.add(ergebnis);
            }
        }
        return new CSVDatei(){

            public Iterable<CSVDatei.CSVZeile> zeilen() {
                return result;
            }

            public String dateiname() {
                return datei.getName();
            }
        };
    }
}

