/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.process.boot;

import com.schneide.base.application.AbstractApplicationEngine;
import com.schneide.base.application.crypt.EncryptionException;
import com.schneide.base.application.process.generic.AbstractBootProcess;
import com.schneide.base.application.usermanagement.crypto.Password;
import com.schneide.base.application.usermanagement.data.BasicSchneideUserGroup;
import com.schneide.base.application.usermanagement.data.CredentialType;
import com.schneide.base.application.usermanagement.data.GenericSchneideCredential;
import com.schneide.base.application.usermanagement.model.Right;
import com.schneide.base.application.usermanagement.model.RightHandler;
import com.schneide.base.application.usermanagement.model.SchneideCredential;
import com.schneide.base.application.usermanagement.model.SchneideUser;
import com.schneide.base.application.usermanagement.model.SchneideUserGroup;
import com.schneide.base.application.usermanagement.model.SchneideUserHandler;
import com.schneide.base.application.usermanagement.model.UserDataHolder;
import com.schneide.base.application.usermanagement.model.UserGroupHandler;
import com.schneide.base.datatypes.collections.iterable.UpcastingIterable;
import com.schneide.base.eventbus.EventBus;
import com.schneide.werp.domain.benutzer.WerpUser;
import com.schneide.werp.domain.benutzer.berechtigung.Berechtigung;
import com.schneide.werp.domain.benutzer.berechtigung.Berechtigungsstufe;
import com.schneide.werp.domain.benutzer.plain.PlainWerpUser;
import com.schneide.werp.domain.session.WerpSession;
import java.util.Optional;

public class SetupInitialUserBootProcess
extends AbstractBootProcess {
    public SetupInitialUserBootProcess(EventBus eventBus) {
        super(eventBus);
    }

    public void activateBoot(AbstractApplicationEngine<WerpSession, PlainWerpUser> applicationEngine) {
        this.legeBenutzergruppenAn(applicationEngine.getUserDataHolder().getSchneideUserGroupHandler(), applicationEngine.getUserDataHolder().getRightHandler());
        UpcastingIterable users = new UpcastingIterable(applicationEngine.getUserManager().getUsers());
        this.handleInternalUserCreation((Iterable<WerpUser>)users, applicationEngine);
        for (PlainWerpUser each : applicationEngine.getUserManager().getUsers()) {
            this.getLogger().debug((Object)("Loaded user " + each.getLogIn() + " (" + each.getFullName() + ")"));
        }
    }

    private void legeBenutzergruppenAn(UserGroupHandler groups, RightHandler rights) {
        for (Berechtigungsstufe each : Berechtigungsstufe.values()) {
            if (groups.hasGroup(each.name())) continue;
            groups.addUserGroup(this.neueGruppeF\u00fcr(each, rights));
        }
    }

    private SchneideUserGroup neueGruppeF\u00fcr(Berechtigungsstufe stufe, RightHandler rechte) {
        BasicSchneideUserGroup newGroup = new BasicSchneideUserGroup(false, this.getEventBus());
        newGroup.setIdentifier(stufe.name());
        newGroup.setName(stufe.bezeichnung());
        newGroup.setIsInternal(false);
        this.statteMitBerechtigungenAus(newGroup, stufe.erlaubnisse(), true, rechte);
        this.statteMitBerechtigungenAus(newGroup, stufe.verbote(), false, rechte);
        newGroup.commit();
        return newGroup;
    }

    private void statteMitBerechtigungenAus(BasicSchneideUserGroup newGroup, Iterable<Berechtigung> berechtigungen, boolean istErlaubt, RightHandler rechte) {
        for (Berechtigung each : berechtigungen) {
            Optional maybeRight = rechte.rightFor(each.getIdentifier());
            maybeRight.ifPresent(right -> newGroup.addCredential((SchneideCredential)new GenericSchneideCredential(right.getIdentifier(), right.getDenotation(), CredentialType.PUBLIC, right.getIsInternal(), istErlaubt)));
        }
    }

    private void handleInternalUserCreation(Iterable<WerpUser> users, AbstractApplicationEngine<WerpSession, PlainWerpUser> applicationEngine) {
        if (!this.isNeedingInternalUser(users)) {
            return;
        }
        this.getLogger().debug((Object)"Creating initial internal users.");
        BenutzerHinzuf\u00fcgen addUser = this.addUserWith(applicationEngine);
        addUser.erstelle("e", "Ent", "Wickler", Berechtigungsstufe.entwickler);
        addUser.erstelle("admin", "Admin", "Istrator", Berechtigungsstufe.administrator);
        addUser.erstelle("werp", "Wer", "Per", Berechtigungsstufe.anwender);
        addUser.erstelle("wieland", "Herr", "Wieland", Berechtigungsstufe.administrator);
        addUser.erstelle("jentner", "Herr", "Jentner", Berechtigungsstufe.administrator);
        addUser.erstelle("b\u00f6ke", "Herr", "B\u00f6ke", Berechtigungsstufe.anwender);
        addUser.erstelle("schiefer", "Herr", "Schiefer", Berechtigungsstufe.anwender);
        addUser.erstelle("sielaff", "Herr", "Sielaff", Berechtigungsstufe.anwender);
    }

    private BenutzerHinzuf\u00fcgen addUserWith(AbstractApplicationEngine<WerpSession, PlainWerpUser> applicationEngine) {
        return (login, vorname, nachname, stufe) -> {
            String password = login;
            try {
                PlainWerpUser user = new PlainWerpUser(login, vorname, nachname, Password.fromPlaintext((String)password), this.isDeveloper(login), this.getEventBus());
                user.changePassword(password);
                if (stufe.equals((Object)Berechtigungsstufe.entwickler)) {
                    user.addCredential(this.getRootCredential(true, (UserDataHolder<PlainWerpUser>)applicationEngine.getUserDataHolder()));
                }
                if (!this.isDeveloper(login)) {
                    Optional developmentMenu = applicationEngine.getUserDataHolder().getRightHandler().rightFor("menu.development");
                    developmentMenu.ifPresent(right -> user.addCredential(GenericSchneideCredential.buildSchneideCredential((Right)right, (boolean)false, (boolean)false)));
                }
                this.gruppeF\u00fcr(stufe, applicationEngine.getUserDataHolder().getSchneideUserGroupHandler()).ifPresent(gruppe -> user.addUserGroup((SchneideUserGroup)gruppe));
                SchneideUserHandler userHandler = applicationEngine.getUserDataHolder().getUserHandler();
                userHandler.add((SchneideUser)user);
                this.getLogger().info((Object)("Added user " + login + " with default password."));
            }
            catch (EncryptionException e) {
                this.getLogger().fatal((Object)"Could not create default user because the password encryption didn't work.", (Throwable)e);
            }
        };
    }

    private boolean isDeveloper(String login) {
        return "e".equals(login);
    }

    private Optional<SchneideUserGroup> gruppeF\u00fcr(Berechtigungsstufe stufe, UserGroupHandler groups) {
        return groups.groupFor(stufe.name());
    }

    private SchneideCredential getRootCredential(boolean isInternalUser, UserDataHolder<PlainWerpUser> userDataHolder) {
        return GenericSchneideCredential.buildSchneideCredential((Right)userDataHolder.getRightHandler().getRootRight(), (boolean)true, (boolean)isInternalUser);
    }

    private boolean isNeedingInternalUser(Iterable<WerpUser> users) {
        for (WerpUser each : users) {
            if (!each.getIsInternal()) continue;
            return false;
        }
        return true;
    }

    private static interface BenutzerHinzuf\u00fcgen {
        public void erstelle(String var1, String var2, String var3, Berechtigungsstufe var4);
    }
}

