/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.gui.input;

import com.schneide.werp.domain.entit\u00e4t.Entit\u00e4t;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

public final class Kontextmen\u00fc {
    private final JComponent widget;

    private Kontextmen\u00fc(JComponent widget) {
        this.widget = widget;
    }

    public static Kontextmen\u00fc f\u00fcr(JComponent widget) {
        return new Kontextmen\u00fc(widget);
    }

    public void mit(Function<JComponent, JPopupMenu> men\u00fc) {
        this.widget.addMouseListener(this.popupListener(men\u00fc));
    }

    protected MouseListener popupListener(final Function<JComponent, JPopupMenu> men\u00fc) {
        MouseAdapter result = new MouseAdapter(this){

            @Override
            public void mousePressed(MouseEvent e) {
                this.checkPopup(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                this.checkPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.checkPopup(e);
            }

            private void checkPopup(MouseEvent e) {
                Component selectedComponent;
                if (e.isPopupTrigger() && (selectedComponent = e.getComponent()) instanceof JComponent) {
                    JComponent swing = (JComponent)selectedComponent;
                    ((JPopupMenu)men\u00fc.apply(swing)).show(swing, e.getX(), e.getY());
                }
            }
        };
        return result;
    }

    public static <E extends Entit\u00e4t> JPopupMenu erstellenF\u00fcr(E entit\u00e4t, Iterable<Eintrag<E>> eintr\u00e4ge) {
        JPopupMenu result = new JPopupMenu(entit\u00e4t.nummer().alsText());
        for (Eintrag<E> each : eintr\u00e4ge) {
            each.davor().ifPresent(result::add);
            result.add(each.alsMenuItem(entit\u00e4t));
            each.danach().ifPresent(result::add);
        }
        return result;
    }

    public static class Eintrag<E extends Entit\u00e4t> {
        private final String titel;
        private final Consumer<? super E> aktion;
        private boolean separatorDavor;
        private boolean separatorDanach;

        public Eintrag(String titel, Consumer<? super E> aktion) {
            this(titel, aktion, false, false);
        }

        public Eintrag(String titel, Consumer<? super E> aktion, boolean separatorDavor, boolean separatorDanach) {
            this.titel = titel;
            this.aktion = aktion;
            this.separatorDavor = separatorDavor;
            this.separatorDanach = separatorDanach;
        }

        public Optional<JSeparator> davor() {
            return Optional.of(new JSeparator()).filter(j -> this.separatorDavor);
        }

        public Optional<JSeparator> danach() {
            return Optional.of(new JSeparator()).filter(j -> this.separatorDanach);
        }

        public JMenuItem alsMenuItem(E entit\u00e4t) {
            JMenuItem result = new JMenuItem(this.titel);
            result.addActionListener(e -> this.aktion.accept(entit\u00e4t));
            return result;
        }
    }
}

