/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.gui.component;

import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.io.virtual.local.LocalVirtualFile;
import com.schneide.werp.domain.session.WerpSession;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class AuswahlMehrererDateien {
    private final File arbeitsverzeichnis;
    private final Iterable<String> endungen;
    private final String beschreibung;

    public AuswahlMehrererDateien(File arbeitsverzeichnis, String beschreibung, String ... endungen) {
        this.arbeitsverzeichnis = arbeitsverzeichnis;
        this.beschreibung = beschreibung;
        this.endungen = List.of(endungen);
    }

    public Iterable<VirtualFile> selectedFiles(WerpSession session) {
        JFileChooser fileChooser = new JFileChooser(this.arbeitsverzeichnis);
        fileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                for (String each : AuswahlMehrererDateien.this.endungen) {
                    if (!f.getName().endsWith(each)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String getDescription() {
                return AuswahlMehrererDateien.this.beschreibung;
            }
        });
        fileChooser.setMultiSelectionEnabled(true);
        int answer = fileChooser.showOpenDialog(session.getMainWindowStack().getActiveWindow());
        if (answer != 0) {
            return Collections.emptyList();
        }
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (File each : fileChooser.getSelectedFiles()) {
            result.add((VirtualFile)new LocalVirtualFile(each));
        }
        return result;
    }
}

