/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.gui.component;

import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.io.virtual.local.LocalVirtualFile;
import com.schneide.werp.domain.session.WerpSession;
import java.io.File;
import java.util.List;
import java.util.Optional;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class AuswahlEinerDatei {
    private final File arbeitsverzeichnis;
    private final Iterable<String> endungen;
    private final String beschreibung;

    public AuswahlEinerDatei(File arbeitsverzeichnis, String beschreibung, String ... endungen) {
        this.arbeitsverzeichnis = arbeitsverzeichnis;
        this.beschreibung = beschreibung;
        this.endungen = List.of(endungen);
    }

    public Optional<VirtualFile> selectFile(WerpSession session) {
        JFileChooser fileChooser = new JFileChooser(this.arbeitsverzeichnis);
        fileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                for (String each : AuswahlEinerDatei.this.endungen) {
                    if (!f.getName().endsWith(each)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String getDescription() {
                return AuswahlEinerDatei.this.beschreibung;
            }
        });
        fileChooser.setMultiSelectionEnabled(false);
        int answer = fileChooser.showOpenDialog(session.getMainWindowStack().getActiveWindow());
        if (answer != 0) {
            return Optional.empty();
        }
        return Optional.ofNullable(fileChooser.getSelectedFile()).map(LocalVirtualFile::new);
    }
}

