/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.domain.benutzer.speicherung;

import com.schneide.base.io.stream.provider.StreamPair;
import com.schneide.base.io.tools.IOCloser;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.logging.LoggedObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public class PropertyBasedPersistence
extends LoggedObject {
    private final StreamPair encryption;

    public PropertyBasedPersistence(StreamPair encryption) {
        this.encryption = encryption;
    }

    private StreamPair encryption() {
        return this.encryption;
    }

    protected Properties loadPropertiesFrom(VirtualFile file) throws IOException {
        Properties result = new Properties();
        try (InputStream decrypted = this.encryption().wrap(file.getInputStream());){
            result.load(decrypted);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void persistTo(Properties properties, VirtualFile target) throws IOException {
        OutputStream encrypted = null;
        try {
            encrypted = this.encryption().wrap(target.getOutputStream());
            properties.store(encrypted, "don't mess with this");
        }
        catch (Throwable throwable) {
            IOCloser.close(encrypted);
            throw throwable;
        }
        IOCloser.close((OutputStream)encrypted);
    }
}

