/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.domain.benutzer.speicherung;

import com.schneide.base.application.usermanagement.data.BasicSchneideUserGroup;
import com.schneide.base.application.usermanagement.model.SchneideCredential;
import com.schneide.base.application.usermanagement.model.SchneideUserGroup;
import com.schneide.base.application.usermanagement.model.UserGroupHandler;
import com.schneide.base.application.usermanagement.news.UserGroupChanged;
import com.schneide.base.configuration.domain.ConfigurationLocationOf;
import com.schneide.base.eventbus.EventBus;
import com.schneide.base.eventbus.util.Subscriber;
import com.schneide.base.io.stream.provider.StreamPair;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.io.virtual.local.LocalVirtualFile;
import com.schneide.base.logging.LoggedObject;
import com.schneide.werp.domain.benutzer.speicherung.CredentialPersister;
import com.schneide.werp.domain.benutzer.speicherung.PropertyBasedPersistence;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class EncryptedUserGroupPersister
extends LoggedObject
implements UserGroupHandler {
    private static final String groupsPath = String.valueOf(ConfigurationLocationOf.stores()) + "/authentication/groups";
    private static final String groupFileEnding = ".group";
    private final Subscriber<UserGroupChanged> groupChange = new Subscriber(UserGroupChanged.class, news -> this.addUserGroup(news.changedGroup()));
    private final PropertyBasedPersistence persistence;
    private final Set<SchneideUserGroup> cache;
    private final EventBus eventBus;

    public EncryptedUserGroupPersister(StreamPair encryption, EventBus eventBus) {
        this.eventBus = eventBus;
        this.persistence = new PropertyBasedPersistence(encryption);
        this.cache = new HashSet<SchneideUserGroup>();
        Subscriber.attach(this.groupChange, (EventBus)eventBus);
    }

    protected VirtualFile fileFor(SchneideUserGroup group) throws IOException {
        return this.groupsDirectory().createFile(group.getName() + groupFileEnding);
    }

    protected VirtualFile groupsDirectory() throws IOException {
        return LocalVirtualFile.directoryAt((String)groupsPath).createAsDirectory();
    }

    protected Iterable<? extends VirtualFile> allGroupFiles() throws IOException {
        return this.groupsDirectory().listDirectory(f -> f.getName().endsWith(groupFileEnding));
    }

    public void load() throws IOException {
        ArrayList<GroupResolveAttempt> resolutions = new ArrayList<GroupResolveAttempt>();
        for (VirtualFile virtualFile : this.allGroupFiles()) {
            Properties properties = this.persistence.loadPropertiesFrom(virtualFile);
            BasicSchneideUserGroup newGroup = new BasicSchneideUserGroup(false, this.eventBus);
            newGroup.setIdentifier(properties.getProperty("identifier"));
            newGroup.setName(properties.getProperty("name"));
            newGroup.setIsInternal(Boolean.parseBoolean(properties.getProperty("internal")));
            if (properties.containsKey("parent")) {
                resolutions.add(new GroupResolveAttempt(this, newGroup, properties.getProperty("parent")));
            }
            Iterable<SchneideCredential> credentials = new CredentialPersister().loadFrom(properties);
            for (SchneideCredential credential : credentials) {
                newGroup.addCredential(credential);
            }
            newGroup.commit();
            this.cache.add((SchneideUserGroup)newGroup);
        }
        for (GroupResolveAttempt groupResolveAttempt : resolutions) {
            groupResolveAttempt.resolveWith(this.getUserGroups());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserGroup(SchneideUserGroup group) {
        if (!group.isCommitted()) {
            return;
        }
        Set<SchneideUserGroup> set = this.cache;
        synchronized (set) {
            Properties properties = new Properties();
            properties.setProperty("identifier", group.getIdentifier());
            properties.setProperty("name", group.getName());
            properties.setProperty("internal", Boolean.toString(group.getIsInternal()));
            if (group.hasParentGroup()) {
                properties.setProperty("parent", group.getParentGroup().getIdentifier());
            }
            new CredentialPersister().storeInto(properties, group.getCredentials());
            this.persist(properties, group);
            this.cache.add(group);
        }
    }

    protected void persist(Properties properties, SchneideUserGroup group) {
        try {
            VirtualFile target = this.fileFor(group).createAsFile();
            this.persistence.persistTo(properties, target);
        }
        catch (IOException e) {
            this.getLogger().error((Object)("Cannot store user group information for " + group.getName()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteUserGroup(SchneideUserGroup group) {
        Set<SchneideUserGroup> set = this.cache;
        synchronized (set) {
            try {
                this.fileFor(group).dispose();
                this.cache.remove(group);
            }
            catch (IOException e) {
                this.getLogger().error((Object)("Could not delete user group information for " + group.getName()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<SchneideUserGroup> getUserGroups() {
        Set<SchneideUserGroup> set = this.cache;
        synchronized (set) {
            return new ArrayList<SchneideUserGroup>(this.cache);
        }
    }

    public void notifyUserGroupValueChanged(SchneideUserGroup group) {
        this.getLogger().debug((Object)("Value changed of user group " + group.getName()));
    }

    private class GroupResolveAttempt {
        private final BasicSchneideUserGroup target;
        private final String parentIdentifier;

        public GroupResolveAttempt(EncryptedUserGroupPersister encryptedUserGroupPersister, BasicSchneideUserGroup target, String parentIdentifier) {
            this.target = target;
            this.parentIdentifier = parentIdentifier;
        }

        public void resolveWith(Iterable<SchneideUserGroup> allGroups) {
            for (SchneideUserGroup each : allGroups) {
                if (!this.parentIdentifier.equals(each.getIdentifier())) continue;
                this.target.setParentGroup(each);
            }
        }
    }
}

