/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.domain.benutzer.berechtigung;

import com.schneide.werp.domain.benutzer.berechtigung.Berechtigung;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public enum Berechtigungsstufe {
    anwender("Anwender", Berechtigungsstufe.anwendungszugang()),
    administrator("Administrator", Berechtigungsstufe.administrationszugang()),
    entwickler("Entwickler", Berechtigungsstufe.administrationszugang());

    private final String bezeichnung;
    private final Iterable<Berechtigung> berechtigungen;
    private final Iterable<Berechtigung> verbote;

    private static Berechtigungen anwendungszugang() {
        return Berechtigungen.keine.mit(Berechtigung.anmelden, Berechtigung.anmeldenAufAdminoberfl\u00e4che, Berechtigung.men\u00fcDerAdminoberfl\u00e4che);
    }

    private static Berechtigungen administrationszugang() {
        return Berechtigungsstufe.anwendungszugang().mit(new Berechtigung[0]);
    }

    private Berechtigungsstufe(String bezeichnung, Berechtigungen berechtigungen) {
        this(bezeichnung, berechtigungen.erlaubt(), berechtigungen.nichtErlaubt());
    }

    private Berechtigungsstufe(String bezeichnung, Iterable<Berechtigung> berechtigungen, Iterable<Berechtigung> verbote) {
        this.bezeichnung = bezeichnung;
        this.berechtigungen = berechtigungen;
        this.verbote = verbote;
    }

    public String bezeichnung() {
        return this.bezeichnung;
    }

    public Iterable<Berechtigung> erlaubnisse() {
        return this.berechtigungen;
    }

    public Iterable<Berechtigung> verbote() {
        return this.verbote;
    }

    private static class Berechtigungen {
        public static final Berechtigungen keine = new Berechtigungen();
        private final List<Berechtigung> erlaubt = new ArrayList<Berechtigung>();
        private final List<Berechtigung> nichtErlaubt = new ArrayList<Berechtigung>();

        public Berechtigungen mit(Berechtigung ... berechtigungen) {
            return this.mit(Arrays.asList(berechtigungen));
        }

        public Berechtigungen mit(Iterable<Berechtigung> berechtigungen) {
            Berechtigungen result = this.copy();
            for (Berechtigung each : berechtigungen) {
                result.erlaubt.add(each);
                result.nichtErlaubt.remove((Object)each);
            }
            return result;
        }

        private Berechtigungen copy() {
            Berechtigungen result = new Berechtigungen();
            result.erlaubt.addAll(this.erlaubt);
            result.nichtErlaubt.addAll(this.nichtErlaubt);
            return result;
        }

        public Iterable<Berechtigung> erlaubt() {
            return this.erlaubt;
        }

        public Iterable<Berechtigung> nichtErlaubt() {
            return this.nichtErlaubt;
        }
    }
}

