/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.domain.benutzer;

import com.schneide.base.application.usermanagement.model.SchneideUser;
import com.schneide.base.application.usermanagement.model.UserManager;
import com.schneide.werp.domain.benutzer.WerpUser;
import com.schneide.werp.domain.benutzer.plain.PlainWerpUser;
import java.util.Optional;
import java.util.function.Function;

public class UserFinder {
    private final UserManager<PlainWerpUser> userManager;

    public UserFinder(UserManager<PlainWerpUser> userManager) {
        this.userManager = userManager;
    }

    public Optional<PlainWerpUser> findUserForIdentifier(String identifier) {
        return this.findUserFor(identifier, SchneideUser::getIdentifier);
    }

    private Optional<PlainWerpUser> findUserFor(String merkmal, Function<WerpUser, String> merkmalExtrahierer) {
        if (null == merkmal) {
            return Optional.empty();
        }
        for (PlainWerpUser user : this.userManager.getUsers()) {
            if (!merkmal.equals(merkmalExtrahierer.apply(user))) continue;
            return Optional.of(user);
        }
        return Optional.empty();
    }

    public Optional<PlainWerpUser> findUserForLogin(String login) {
        return this.findUserFor(login, SchneideUser::getLogIn);
    }
}

