/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.process.desktop;

import com.schneide.base.datatypes.collections.CollectionUtil;
import com.schneide.base.datatypes.collections.iterable.IterableUtil;
import com.schneide.base.datatypes.collections.iterable.TransformingIterable;
import com.schneide.base.gui.dialog.defaults.DefaultDialog;
import com.schneide.base.gui.model.WindowStack;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.io.virtual.local.LocalVirtualFile;
import com.schneide.werp.domain.artikel.ArtikelRepository;
import com.schneide.werp.domain.erf\u00fcllung.auftrag.Arbeitsauftrag;
import com.schneide.werp.domain.erf\u00fcllung.produktion.Produktionsliste;
import com.schneide.werp.domain.erf\u00fcllung.schritt.ArbeitsschrittRepository;
import com.schneide.werp.domain.erf\u00fcllung.st\u00fcckliste.St\u00fccklistenbehaftet;
import com.schneide.werp.domain.erf\u00fcllung.weg.Erf\u00fcllungswegRepository;
import com.schneide.werp.domain.erf\u00fcllung.zusammenfassung.Laufzettel;
import com.schneide.werp.domain.erf\u00fcllung.zusammenfassung.Vorzugslaufzettel;
import com.schneide.werp.domain.oberfl\u00e4che.Oberfl\u00e4chenbehandlungRepository;
import com.schneide.werp.domain.produktion.Produktionsnummer;
import com.schneide.werp.domain.projekt.Projekt;
import com.schneide.werp.domain.projekt.ProjektRepository;
import com.schneide.werp.domain.publishing.Report;
import com.schneide.werp.domain.session.WerpSession;
import com.schneide.werp.engine.filesystem.Dateiname;
import com.schneide.werp.engine.periphery.Anwendungsumgebung;
import com.schneide.werp.periphery.dokumenterstellung.Dokumenterstellung;
import com.schneide.werp.process.generic.WerpProcess;
import com.schneide.werp.produktion.engine.Arbeitsauftr\u00e4geErstellen;
import com.schneide.werp.produktion.engine.LaufzettelErstellen;
import com.schneide.werp.produktion.gui.dialog.Oberfl\u00e4chenauswahldialog;
import com.schneide.werp.produktion.gui.dialog.Projektauswahldialog;
import com.schneide.werp.produktion.gui.frame.ProduktionslistenFrame;
import com.schneide.werp.produktion.model.repository.BeschreibbaresArbeitsauftragRepository;
import com.schneide.werp.produktion.model.repository.BeschreibbaresProduktionsartikelRepository;
import com.schneide.werp.produktion.output.Arbeitsauftr\u00e4geAlsPDF;
import com.schneide.werp.produktion.output.LaufzettelAlsPDF;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ProjektproduktionFreigeben
extends WerpProcess {
    public ProjektproduktionFreigeben(WerpSession session) {
        super(session);
    }

    public void activateFor(ProjektRepository projekte, ArtikelRepository artikel, Erf\u00fcllungswegRepository erf\u00fcllungswege, ArbeitsschrittRepository arbeitsschritte, BeschreibbaresProduktionsartikelRepository produktionsartikel, BeschreibbaresArbeitsauftragRepository arbeitsauftr\u00e4ge, Oberfl\u00e4chenbehandlungRepository oberfl\u00e4chen, Anwendungsumgebung umgebung) {
        Projektauswahldialog projektwahl = new Projektauswahldialog((WerpSession)this.session(), projekte);
        Optional maybeProjekt = projektwahl.showDialog();
        if (maybeProjekt.isEmpty()) {
            this.getLogger().info((Object)"Kein Projekt ausgew\u00e4hlt.");
            return;
        }
        Projekt zuProduzieren = (Projekt)maybeProjekt.get();
        this.getLogger().debug((Object)St\u00fccklistenbehaftet.alsText((St\u00fccklistenbehaftet)zuProduzieren));
        Produktionsliste rohliste = Produktionsliste.f\u00fcr((Projekt)zuProduzieren);
        Oberfl\u00e4chenauswahldialog oberfl\u00e4chenauswahl = new Oberfl\u00e4chenauswahldialog((WerpSession)this.session(), zuProduzieren, rohliste, oberfl\u00e4chen);
        Optional maybeAusgew\u00e4hlt = oberfl\u00e4chenauswahl.showDialog();
        if (maybeAusgew\u00e4hlt.isEmpty()) {
            return;
        }
        Produktionsliste mitOberfl\u00e4chen = (Produktionsliste)maybeAusgew\u00e4hlt.get();
        mitOberfl\u00e4chen.hierarchieAlsListe().forEach(ple -> {
            try {
                produktionsartikel.speichere(ple.artikel());
            }
            catch (IOException e) {
                this.getLogger().error((Object)("Fehler beim Speichern des Produktionsartikel: " + String.valueOf(ple)), (Throwable)e);
            }
        });
        Iterable<Arbeitsauftrag> neueArbeitsauftr\u00e4ge = new Arbeitsauftr\u00e4geErstellen(artikel, erf\u00fcllungswege, arbeitsschritte).f\u00fcr(zuProduzieren.produktionsnummer(), mitOberfl\u00e4chen);
        neueArbeitsauftr\u00e4ge.forEach(aa -> {
            try {
                arbeitsauftr\u00e4ge.speichere((Arbeitsauftrag)aa);
                arbeitsauftr\u00e4ge.bearbeitung().unfertig(aa.identifikation());
            }
            catch (IOException e) {
                this.getLogger().error((Object)("Fehler beim Speichern des Arbeitsauftrags " + String.valueOf(aa)), (Throwable)e);
            }
        });
        ArrayList laufzettel = new ArrayList();
        LaufzettelErstellen laufzettelerstellung = new LaufzettelErstellen(arbeitsauftr\u00e4ge);
        Iterable<? extends Laufzettel> erstellteLaufzettel = laufzettelerstellung.f\u00fcr(zuProduzieren.produktionsnummer(), neueArbeitsauftr\u00e4ge);
        CollectionUtil.addAll(laufzettel, erstellteLaufzettel);
        Iterable vorzugslaufzettel = Vorzugslaufzettel.erstellenF\u00fcr((Produktionsnummer)zuProduzieren.produktionsnummer(), neueArbeitsauftr\u00e4ge);
        CollectionUtil.addAll(laufzettel, (Iterable)vorzugslaufzettel);
        this.getLogger().info((Object)(IterableUtil.getSizeFor(neueArbeitsauftr\u00e4ge) + " Arbeitsauftr\u00e4ge erstellt."));
        this.getLogger().info((Object)(IterableUtil.getSizeFor(laufzettel) + " Laufzettel erstellt."));
        try {
            LocalVirtualFile auftragsverzeichnis = LocalVirtualFile.directoryAt((String)"dokumente/auftr\u00e4ge/txt");
            for (Arbeitsauftrag each : neueArbeitsauftr\u00e4ge) {
                VirtualFile auftragsdatei = auftragsverzeichnis.getChild(each.identifikation().alsText() + ".txt");
                auftragsdatei.setContentTo(each.toString());
            }
        }
        catch (IOException e) {
            this.getLogger().error((Object)"Fehler beim Speichern der Arbeitsauftr\u00e4ge.", (Throwable)e);
        }
        try {
            LocalVirtualFile laufzettelverzeichnis = LocalVirtualFile.directoryAt((String)"dokumente/laufzettel/txt");
            for (Arbeitsauftrag each : laufzettel) {
                VirtualFile laufzetteldatei = laufzettelverzeichnis.getChild(each.identifier() + ".txt");
                laufzetteldatei.setContentTo(each.inTextuellerDarstellung());
            }
        }
        catch (IOException e) {
            this.getLogger().error((Object)"Fehler beim Speichern der Laufzettel.", (Throwable)e);
        }
        umgebung.dokumenterstellung().ifPresent(de -> ProjektproduktionFreigeben.speichereArbeitsauftr\u00e4geAlsPDF(zuProduzieren, neueArbeitsauftr\u00e4ge, de));
        umgebung.dokumenterstellung().ifPresent(de -> ProjektproduktionFreigeben.speichereLaufzettelAlsPDF(zuProduzieren, laufzettel, de));
        DefaultDialog.showInformationDialog((WindowStack)((WerpSession)this.session()).getMainWindowStack(), (String)("Arbeitsauftr\u00e4ge f\u00fcr " + String.valueOf(zuProduzieren.nummer()) + " erstellt"), (String)(IterableUtil.getSizeFor(neueArbeitsauftr\u00e4ge) + " Arbeitsauftr\u00e4ge f\u00fcr Projekt " + String.valueOf(zuProduzieren) + " erstellt"));
        ProduktionslistenFrame anzeige = new ProduktionslistenFrame((WerpSession)this.session(), mitOberfl\u00e4chen, neueArbeitsauftr\u00e4ge);
        anzeige.show();
    }

    private static void speichereArbeitsauftr\u00e4geAlsPDF(Projekt projekt, Iterable<Arbeitsauftrag> auftr\u00e4ge, Dokumenterstellung erstellung) {
        Dokumenterstellung.speichere((Report)new Arbeitsauftr\u00e4geAlsPDF().f\u00fcr(projekt.beschreibung(), (Iterable<Arbeitsauftr\u00e4geAlsPDF.Ausdruckangaben>)new TransformingIterable(Arbeitsauftr\u00e4geAlsPDF.Ausdruckangaben::ohneNachfolgerF\u00fcr, auftr\u00e4ge)), (String)"dokumente/auftr\u00e4ge/pdf/gesamt", (String)(Dateiname.g\u00fcltigF\u00fcr((String)projekt.nummer().alsText()) + "-auftr\u00e4ge.pdf"), (Dokumenterstellung)erstellung);
        for (Arbeitsauftrag each : auftr\u00e4ge) {
            Dokumenterstellung.speichere((Report)new Arbeitsauftr\u00e4geAlsPDF().f\u00fcr(projekt.beschreibung(), List.of(Arbeitsauftr\u00e4geAlsPDF.Ausdruckangaben.ohneNachfolgerF\u00fcr(each))), (String)"dokumente/auftr\u00e4ge/pdf/einzeln", (String)(Dateiname.g\u00fcltigF\u00fcr((String)each.identifikation().alsText()) + ".pdf"), (Dokumenterstellung)erstellung);
        }
    }

    private static void speichereLaufzettelAlsPDF(Projekt projekt, Iterable<? extends Laufzettel> laufzettel, Dokumenterstellung erstellung) {
        Dokumenterstellung.speichere((Report)new LaufzettelAlsPDF().f\u00fcr(projekt.produktionsnummer(), projekt.beschreibung(), laufzettel), (String)"dokumente/laufzettel/pdf/gesamt", (String)(Dateiname.g\u00fcltigF\u00fcr((String)projekt.nummer().alsText()) + "-laufzettel.pdf"), (Dokumenterstellung)erstellung);
        for (Laufzettel laufzettel2 : laufzettel) {
            Dokumenterstellung.speichere((Report)new LaufzettelAlsPDF().f\u00fcr(projekt.produktionsnummer(), projekt.beschreibung(), List.of(laufzettel2)), (String)"dokumente/laufzettel/pdf/einzeln", (String)(Dateiname.g\u00fcltigF\u00fcr((String)laufzettel2.identifier()) + ".pdf"), (Dokumenterstellung)erstellung);
        }
    }
}

