/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.process.desktop;

import com.schneide.base.datatypes.optional.OptionalUtil;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.werp.domain.erf\u00fcllung.schritt.ArbeitsschrittRepository;
import com.schneide.werp.domain.erf\u00fcllung.weg.BeschreibbaresErf\u00fcllungswegRepository;
import com.schneide.werp.domain.erf\u00fcllung.weg.Erf\u00fcllungswegRepository;
import com.schneide.werp.domain.session.WerpSession;
import com.schneide.werp.engine.periphery.Anwendungsumgebung;
import com.schneide.werp.gui.component.AuswahlEinerDatei;
import com.schneide.werp.periphery.datenimport.Datenimport;
import com.schneide.werp.process.generic.WerpProcess;
import com.schneide.werp.produktion.model.repository.filebased.excel.ExcelbasiertesErf\u00fcllungswegRepository;
import java.io.File;
import java.io.IOException;
import java.util.Optional;

public class Erf\u00fcllungswegeImportieren
extends WerpProcess {
    public Erf\u00fcllungswegeImportieren(WerpSession session) {
        super(session);
    }

    public void activateFor(BeschreibbaresErf\u00fcllungswegRepository erf\u00fcllungswege, ArbeitsschrittRepository arbeitsschritte, Anwendungsumgebung umgebung) {
        Iterable<VirtualFile> toImport = this.selectedFiles();
        this.importierenVon(toImport, erf\u00fcllungswege, arbeitsschritte, umgebung);
    }

    public void importierenVon(Iterable<VirtualFile> dateien, BeschreibbaresErf\u00fcllungswegRepository erf\u00fcllungswege, ArbeitsschrittRepository arbeitsschritte, Anwendungsumgebung umgebung) {
        Optional maybeImport = umgebung.datenimport();
        if (maybeImport.isEmpty()) {
            return;
        }
        Datenimport importierung = (Datenimport)maybeImport.get();
        int summe = 0;
        for (VirtualFile each : dateien) {
            try {
                ExcelbasiertesErf\u00fcllungswegRepository geladeneErf\u00fcllungswege = new ExcelbasiertesErf\u00fcllungswegRepository(each.getLocalFile(), importierung.ausExcel(), arbeitsschritte);
                int geladeneSumme = geladeneErf\u00fcllungswege.anzahl();
                summe += geladeneSumme;
                this.getLogger().info((Object)(geladeneSumme + " Erf\u00fcllungswege geladen."));
                erf\u00fcllungswege.f\u00fcgeAllesHinzuVon((Erf\u00fcllungswegRepository)geladeneErf\u00fcllungswege);
            }
            catch (IOException e) {
                this.getLogger().error((Object)("Fehler beim Import der Erf\u00fcllungswege aus " + String.valueOf(each)), (Throwable)e);
            }
        }
        this.meldeInStatuszeile(summe + " Erf\u00fcllungswege importiert.");
        this.getLogger().info((Object)"Import abgeschlossen.");
    }

    private Iterable<VirtualFile> selectedFiles() {
        AuswahlEinerDatei auswahl = new AuswahlEinerDatei(new File("."), "Erf\u00fcllungswegdefinition (*.xlsx)", new String[]{".xlsx"});
        return OptionalUtil.asIterable((Optional)auswahl.selectFile((WerpSession)this.session()));
    }
}

