/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.process.desktop;

import com.schneide.base.datatypes.optional.OptionalUtil;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.werp.domain.erf\u00fcllung.schritt.ArbeitsschrittRepository;
import com.schneide.werp.domain.erf\u00fcllung.schritt.ErweiterbaresArbeitsschrittRepository;
import com.schneide.werp.domain.session.WerpSession;
import com.schneide.werp.engine.periphery.Anwendungsumgebung;
import com.schneide.werp.gui.component.AuswahlEinerDatei;
import com.schneide.werp.periphery.datenimport.Datenimport;
import com.schneide.werp.process.generic.WerpProcess;
import com.schneide.werp.produktion.model.repository.filebased.excel.ExcelbasiertesArbeitsschrittRepository;
import java.io.File;
import java.io.IOException;
import java.util.Optional;

public class ArbeitsschritteImportieren
extends WerpProcess {
    public ArbeitsschritteImportieren(WerpSession session) {
        super(session);
    }

    public void activateFor(ErweiterbaresArbeitsschrittRepository arbeitsschritte, Anwendungsumgebung umgebung) {
        Iterable<VirtualFile> toImport = this.selectedFiles();
        this.importierenVon(toImport, arbeitsschritte, umgebung);
    }

    public void importierenVon(Iterable<VirtualFile> dateien, ErweiterbaresArbeitsschrittRepository arbeitsschritte, Anwendungsumgebung umgebung) {
        Optional maybeImport = umgebung.datenimport();
        if (maybeImport.isEmpty()) {
            return;
        }
        Datenimport importierung = (Datenimport)maybeImport.get();
        int summe = 0;
        for (VirtualFile each : dateien) {
            try {
                ExcelbasiertesArbeitsschrittRepository geladeneArbeitsschritte = new ExcelbasiertesArbeitsschrittRepository(each.getLocalFile(), importierung.ausExcel());
                int geladeneSumme = geladeneArbeitsschritte.anzahl();
                summe += geladeneSumme;
                this.getLogger().info((Object)(geladeneSumme + " Arbeitsschritte geladen."));
                arbeitsschritte.f\u00fcgeAllesHinzuVon((ArbeitsschrittRepository)geladeneArbeitsschritte);
            }
            catch (IOException e) {
                this.getLogger().error((Object)("Fehler beim Import der Arbeitsschritte aus " + String.valueOf(each)), (Throwable)e);
            }
        }
        this.meldeInStatuszeile(summe + " Arbeitsschritte importiert.");
        this.getLogger().info((Object)"Import abgeschlossen.");
    }

    private Iterable<VirtualFile> selectedFiles() {
        AuswahlEinerDatei auswahl = new AuswahlEinerDatei(new File("."), "Arbeitsschrittdefinition (*.xlsx)", new String[]{".xlsx"});
        return OptionalUtil.asIterable((Optional)auswahl.selectFile((WerpSession)this.session()));
    }
}

