/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.output;

import com.schneide.base.datatypes.collections.iterable.IterableUtil;
import com.schneide.base.maths.Percent;
import com.schneide.base.text.buffer.DirectChunkBuffer;
import com.schneide.werp.domain.material.Blechabmessung;
import com.schneide.werp.domain.material.Blecheinsatz;
import com.schneide.werp.domain.material.Material;
import com.schneide.werp.domain.produktion.Produktionsnummer;
import com.schneide.werp.domain.publishing.Headline;
import com.schneide.werp.domain.publishing.Report;
import com.schneide.werp.domain.publishing.ReportEntry;
import com.schneide.werp.domain.publishing.ReportLine;
import com.schneide.werp.domain.publishing.ReportSection;
import com.schneide.werp.domain.publishing.SectionClosure;
import com.schneide.werp.domain.publishing.detail.Seitengr\u00f6\u00dfe;
import com.schneide.werp.produktion.engine.qrcode.QRCodeF\u00fcr;
import com.schneide.werp.produktion.output.generic.AusgabeAlsPDF;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class BlechberichtAlsPDF
extends AusgabeAlsPDF {
    public Report f\u00fcr(Produktionsnummer produktion, String bezeichnung, Map<Material, Map<Blechabmessung.Blechdicke, List<Blecheinsatz>>> alleBleche) {
        Report dokument = this.neuerReportMit(Seitengr\u00f6\u00dfe.DIN_A4, Percent.fromFactor((double)0.75));
        Set<Map.Entry<Material, Map<Blechabmessung.Blechdicke, List<Blecheinsatz>>>> materalien = alleBleche.entrySet();
        SectionClosure abschluss = materalien.size() == 1 ? SectionClosure.none : SectionClosure.pageBreak;
        Iterator<Map.Entry<Material, Map<Blechabmessung.Blechdicke, List<Blecheinsatz>>>> eintr\u00e4ge = materalien.iterator();
        while (eintr\u00e4ge.hasNext()) {
            Map.Entry<Material, Map<Blechabmessung.Blechdicke, List<Blecheinsatz>>> each = eintr\u00e4ge.next();
            Iterable<ReportSection> sektionen = this.erstelleF\u00fcr("Produktion " + produktion.alsText() + ": " + bezeichnung, each, eintr\u00e4ge.hasNext() ? SectionClosure.none : abschluss);
            sektionen.forEach(arg_0 -> ((Report)dokument).add(arg_0));
        }
        return dokument;
    }

    private Iterable<ReportSection> erstelleF\u00fcr(String titel, Map.Entry<Material, Map<Blechabmessung.Blechdicke, List<Blecheinsatz>>> daten, SectionClosure abschluss) {
        ArrayList<ReportSection> result = new ArrayList<ReportSection>();
        daten.getValue().forEach((dicke, eins\u00e4tze) -> result.addAll(this.sektionenF\u00fcr(titel, (Material)daten.getKey(), (Blechabmessung.Blechdicke)dicke, (List<Blecheinsatz>)eins\u00e4tze)));
        result.add(new ReportSection(abschluss));
        return result;
    }

    private List<ReportSection> sektionenF\u00fcr(String titel, Material material, Blechabmessung.Blechdicke dicke, List<Blecheinsatz> eins\u00e4tze) {
        ArrayList<ReportSection> result = new ArrayList<ReportSection>();
        ReportSection code = new ReportSection(SectionClosure.none);
        result.add(code);
        ReportSection kopfteil = new ReportSection(SectionClosure.boldLine);
        result.add(kopfteil);
        kopfteil.add((ReportEntry)ReportLine.forParts((String[])new String[]{titel}));
        kopfteil.add((ReportEntry)ReportLine.forParts((String[])new String[]{" "}));
        kopfteil.add((ReportEntry)Headline.forReport((String)("Material " + material.bezeichnung() + ", Blechdicke " + dicke.bezeichnung())));
        ReportSection aufstellung = new ReportSection(SectionClosure.line);
        result.add(aufstellung);
        long fl\u00e4chensumme = 0L;
        BigDecimal massensumme = BigDecimal.ZERO;
        DirectChunkBuffer codeinhalt = new DirectChunkBuffer((CharSequence)"\n");
        double abstandZwischenAbschnitten = 0.4;
        for (Blecheinsatz each : eins\u00e4tze) {
            List<ReportLine> abschnitt = List.of(ReportLine.forParts((String[])new String[]{"[   ] " + each.anzahl() + "x " + each.breite() + " mm x " + each.l\u00e4nge() + " mm f\u00fcr Position " + each.koordinate().alsText() + " - " + each.artikel().artikelnummerMitRevision() + ": " + each.artikel().bezeichnung()}), ReportLine.forParts((String[])new String[]{"      Gesamtfl\u00e4che: " + each.gesamtfl\u00e4che() + " mm\u00b2 (" + this.alsQuadratmeter(each.gesamtfl\u00e4che()) + ")"}), ReportLine.forParts((String[])new String[]{"      Gesamtmasse: " + this.nachkommastellen(1).format(each.gesamtmasse()) + " kg"}));
            abschnitt.forEach(rl -> {
                rl.changeLineHeightTo(0.8);
                aufstellung.add((ReportEntry)rl);
            });
            double aktuellerAbstandZwischenAbschnitten = abstandZwischenAbschnitten;
            IterableUtil.first(abschnitt).ifPresent(rl -> rl.changeLineHeightTo(aktuellerAbstandZwischenAbschnitten));
            abstandZwischenAbschnitten = 1.2;
            fl\u00e4chensumme += each.gesamtfl\u00e4che();
            massensumme = massensumme.add(each.gesamtmasse());
            codeinhalt.add((CharSequence)(each.anzahl() + "x " + each.artikel().artikelnummerMitRevision()));
        }
        ReportSection summen = new ReportSection(SectionClosure.pageBreak);
        result.add(summen);
        summen.add((ReportEntry)ReportLine.forParts((String[])new String[]{"Gesamtfl\u00e4che: " + fl\u00e4chensumme + " mm\u00b2"}));
        summen.add((ReportEntry)ReportLine.forParts((String[])new String[]{"Gesamtfl\u00e4che: " + this.alsQuadratmeter(fl\u00e4chensumme)}));
        summen.add((ReportEntry)ReportLine.forParts((String[])new String[]{""}));
        summen.add((ReportEntry)ReportLine.forParts((String[])new String[]{"Gesamtmasse: " + this.nachkommastellen(1).format(massensumme) + " kg"}));
        this.qrCodeIn(code, () -> QRCodeF\u00fcr.text(codeinhalt.asString()));
        return result;
    }

    private String alsQuadratmeter(long quadratmillimeter) {
        return this.nachkommastellen(3).format((double)quadratmillimeter / 1000.0 / 1000.0) + " m\u00b2";
    }

    private DecimalFormat nachkommastellen(int stellen) {
        DecimalFormat formatierung = new DecimalFormat("0." + "0".repeat(stellen), DecimalFormatSymbols.getInstance(Locale.GERMAN));
        return formatierung;
    }
}

