/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.model.repository.inmemory;

import com.schneide.base.logging.LoggedObject;
import com.schneide.werp.domain.erf\u00fcllung.auftrag.Arbeitsauftrag;
import com.schneide.werp.domain.erf\u00fcllung.auftrag.ArbeitsauftragIdentifikation;
import com.schneide.werp.domain.erf\u00fcllung.auftrag.ArbeitsauftragbearbeitungRepository;
import com.schneide.werp.domain.produktion.Produktionsnummer;
import com.schneide.werp.produktion.model.repository.BeschreibbaresArbeitsauftragRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class MemoryBasedArbeitsauftragRepository
extends LoggedObject
implements BeschreibbaresArbeitsauftragRepository,
ArbeitsauftragbearbeitungRepository {
    private final Object lock = new Object();
    private final Map<Produktionsnummer, List<Arbeitsauftrag>> produktionsnummer2Arbeitsauftr\u00e4ge = new HashMap<Produktionsnummer, List<Arbeitsauftrag>>();
    private final Map<ArbeitsauftragIdentifikation, Arbeitsauftrag> identifikation2Arbeitsauftrag = new HashMap<ArbeitsauftragIdentifikation, Arbeitsauftrag>();
    private final Set<ArbeitsauftragIdentifikation> fertiggestellt = new HashSet<ArbeitsauftragIdentifikation>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<Produktionsnummer> verf\u00fcgbareProduktionen() {
        Object object = this.lock;
        synchronized (object) {
            return this.produktionsnummer2Arbeitsauftr\u00e4ge.keySet().stream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<Arbeitsauftrag> alleF\u00fcr(Produktionsnummer projekt) {
        Object object = this.lock;
        synchronized (object) {
            return Optional.ofNullable(this.produktionsnummer2Arbeitsauftr\u00e4ge.get(projekt)).map(Collection::stream).orElseGet(Stream::empty);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Arbeitsauftrag> f\u00fcr(ArbeitsauftragIdentifikation identifikation) {
        Object object = this.lock;
        synchronized (object) {
            return Optional.ofNullable(this.identifikation2Arbeitsauftrag.get(identifikation));
        }
    }

    public ArbeitsauftragbearbeitungRepository bearbeitung() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unfertig(ArbeitsauftragIdentifikation auftrag) {
        Object object = this.lock;
        synchronized (object) {
            this.fertiggestellt.remove(auftrag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stelleFertig(ArbeitsauftragIdentifikation auftrag) {
        Object object = this.lock;
        synchronized (object) {
            this.fertiggestellt.add(auftrag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean istFertiggestellt(ArbeitsauftragIdentifikation auftrag) {
        Object object = this.lock;
        synchronized (object) {
            return this.fertiggestellt.contains(auftrag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void speichere(Arbeitsauftrag neu) {
        Object object = this.lock;
        synchronized (object) {
            this.identifikation2Arbeitsauftrag.put(neu.identifikation(), neu);
            Produktionsnummer projekt = neu.identifikation().projekt();
            if (!this.produktionsnummer2Arbeitsauftr\u00e4ge.containsKey(projekt)) {
                this.produktionsnummer2Arbeitsauftr\u00e4ge.put(projekt, new ArrayList());
            }
            this.produktionsnummer2Arbeitsauftr\u00e4ge.get(projekt).add(neu);
        }
    }
}

