/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.model.repository.filebased.verzeichnis;

import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.io.virtual.filter.VirtualFileFilter;
import com.schneide.base.logging.LoggedObject;
import com.schneide.werp.domain.erf\u00fcllung.schritt.ArbeitsschrittRepository;
import com.schneide.werp.domain.erf\u00fcllung.weg.BeschreibbaresErf\u00fcllungswegRepository;
import com.schneide.werp.domain.erf\u00fcllung.weg.Erf\u00fcllungsweg;
import com.schneide.werp.domain.erf\u00fcllung.weg.Erf\u00fcllungswegRepository;
import com.schneide.werp.engine.filesystem.Dateiname;
import com.schneide.werp.periphery.datenspeicherung.bereiche.Erf\u00fcllungswegDatenspeicherung;
import com.schneide.werp.produktion.model.repository.cache.Erf\u00fcllungswegCache;
import java.io.IOException;
import java.util.Optional;

public class VerzeichnisbasiertesErf\u00fcllungswegRepository
extends LoggedObject
implements BeschreibbaresErf\u00fcllungswegRepository {
    private final VirtualFile basisverzeichnis;
    private final Erf\u00fcllungswegDatenspeicherung persistence;
    private final Erf\u00fcllungswegCache cache;
    private final String entitybezeichnung;
    private final ArbeitsschrittRepository arbeitsschritte;

    public VerzeichnisbasiertesErf\u00fcllungswegRepository(VirtualFile basisverzeichnis, Erf\u00fcllungswegDatenspeicherung persistence, ArbeitsschrittRepository arbeitsschritte) {
        this.basisverzeichnis = basisverzeichnis;
        this.persistence = persistence;
        this.arbeitsschritte = arbeitsschritte;
        this.cache = new Erf\u00fcllungswegCache();
        this.entitybezeichnung = "Erf\u00fcllungsweg";
    }

    public void wiedereinlesen() {
        final String endung = this.persistence.dateiendung();
        Iterable arbeitsschrittdateien = this.basisverzeichnis.listDirectory(new VirtualFileFilter(){

            public boolean accept(VirtualFile f) {
                return f.isFile() && f.getName().endsWith(endung);
            }
        });
        arbeitsschrittdateien.forEach(vf -> {
            try {
                Optional maybeArbeitsschritt = this.persistence.ladeAus(vf);
                maybeArbeitsschritt.ifPresent(this.cache::speichere);
            }
            catch (IOException e) {
                this.getLogger().error((Object)"", (Throwable)e);
            }
        });
        this.getLogger().debug((Object)(this.cache.anzahl() + " " + this.entitybezeichnung + " gecacht."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<Erf\u00fcllungsweg> alle() {
        Erf\u00fcllungswegCache erf\u00fcllungswegCache = this.cache;
        synchronized (erf\u00fcllungswegCache) {
            return this.cache.alle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Erf\u00fcllungsweg> anIndex(int index) {
        Erf\u00fcllungswegCache erf\u00fcllungswegCache = this.cache;
        synchronized (erf\u00fcllungswegCache) {
            return this.cache.anIndex(index);
        }
    }

    public void f\u00fcgeHinzu(Erf\u00fcllungsweg neu) {
        try {
            this.speichere(neu);
        }
        catch (IOException e) {
            this.getLogger().error((Object)("Fehler beim Speichern von " + this.entitybezeichnung + " " + neu.identifier()), (Throwable)e);
        }
    }

    public void f\u00fcgeAllesHinzuVon(Erf\u00fcllungswegRepository anderes) {
        anderes.alle().forEach(this::f\u00fcgeHinzu);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void speichere(Erf\u00fcllungsweg neu) throws IOException {
        neu.arbeitsschritteNormalisierenMit(this.arbeitsschritte);
        String dateiname = Dateiname.g\u00fcltigF\u00fcr((String)neu.identifier());
        VirtualFile zieldatei = this.basisverzeichnis.getChild(dateiname + this.persistence.dateiendung());
        Erf\u00fcllungswegCache erf\u00fcllungswegCache = this.cache;
        synchronized (erf\u00fcllungswegCache) {
            this.persistence.speichere(neu, zieldatei);
            this.cache.speichere(neu);
        }
    }
}

