/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.model.repository.filebased.verzeichnis;

import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.io.virtual.filter.VirtualFileFilter;
import com.schneide.base.logging.LoggedObject;
import com.schneide.werp.domain.erf\u00fcllung.schritt.Arbeitsschritt;
import com.schneide.werp.domain.erf\u00fcllung.schritt.ArbeitsschrittRepository;
import com.schneide.werp.domain.erf\u00fcllung.schritt.ErweiterbaresArbeitsschrittRepository;
import com.schneide.werp.engine.filesystem.Dateiname;
import com.schneide.werp.periphery.datenspeicherung.bereiche.ArbeitsschrittDatenspeicherung;
import com.schneide.werp.produktion.model.repository.cache.ArbeitsschrittCache;
import java.io.IOException;
import java.util.Optional;

public class VerzeichnisbasiertesArbeitsschrittRepository
extends LoggedObject
implements ErweiterbaresArbeitsschrittRepository {
    private final VirtualFile basisverzeichnis;
    private final ArbeitsschrittDatenspeicherung persistence;
    private final ArbeitsschrittCache cache;
    private final String entitybezeichnung;

    public VerzeichnisbasiertesArbeitsschrittRepository(VirtualFile basisverzeichnis, ArbeitsschrittDatenspeicherung persistence) {
        this.basisverzeichnis = basisverzeichnis;
        this.persistence = persistence;
        this.cache = new ArbeitsschrittCache();
        this.entitybezeichnung = "Arbeitsschritt";
    }

    public void wiedereinlesen() {
        final String endung = this.persistence.dateiendung();
        Iterable arbeitsschrittdateien = this.basisverzeichnis.listDirectory(new VirtualFileFilter(){

            public boolean accept(VirtualFile f) {
                return f.isFile() && f.getName().endsWith(endung);
            }
        });
        arbeitsschrittdateien.forEach(vf -> {
            try {
                Optional maybeArbeitsschritt = this.persistence.ladeAus(vf);
                maybeArbeitsschritt.ifPresent(this.cache::speichere);
            }
            catch (IOException e) {
                this.getLogger().error((Object)"", (Throwable)e);
            }
        });
        this.getLogger().debug((Object)(this.cache.anzahl() + " " + this.entitybezeichnung + " gecacht."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<Arbeitsschritt> alle() {
        ArbeitsschrittCache arbeitsschrittCache = this.cache;
        synchronized (arbeitsschrittCache) {
            return this.cache.alle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Arbeitsschritt> anIndex(int index) {
        ArbeitsschrittCache arbeitsschrittCache = this.cache;
        synchronized (arbeitsschrittCache) {
            return this.cache.anIndex(index);
        }
    }

    public void f\u00fcgeAllesHinzuVon(ArbeitsschrittRepository anderes) {
        anderes.alle().forEach(as -> {
            try {
                this.speichere((Arbeitsschritt)as);
            }
            catch (IOException e) {
                this.getLogger().error((Object)("Fehler beim Speichern von " + this.entitybezeichnung + " " + as.nummer()), (Throwable)e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void speichere(Arbeitsschritt neuerSchritt) throws IOException {
        String dateiname = Dateiname.g\u00fcltigF\u00fcr((String)neuerSchritt.nummer());
        VirtualFile zieldatei = this.basisverzeichnis.getChild(dateiname + this.persistence.dateiendung());
        ArbeitsschrittCache arbeitsschrittCache = this.cache;
        synchronized (arbeitsschrittCache) {
            this.persistence.speichere(neuerSchritt, zieldatei);
            this.cache.speichere(neuerSchritt);
        }
    }
}

