/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.model.repository.filebased.excel;

import com.schneide.werp.domain.erf\u00fcllung.schritt.Arbeitsschritt;
import com.schneide.werp.domain.erf\u00fcllung.schritt.ArbeitsschrittRepository;
import com.schneide.werp.domain.erf\u00fcllung.schritt.Erf\u00fcllungsschritt;
import com.schneide.werp.domain.erf\u00fcllung.weg.Erf\u00fcllungsweg;
import com.schneide.werp.domain.erf\u00fcllung.weg.Erf\u00fcllungswegRepository;
import com.schneide.werp.domain.format.excel.Exceldatei;
import com.schneide.werp.model.repository.excelbased.ExcelbasiertesRepository;
import com.schneide.werp.periphery.datenimport.lader.ExcelLader;
import com.schneide.werp.produktion.engine.ParallelenErf\u00fcllungswegEinlesen;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;

public class ExcelbasiertesErf\u00fcllungswegRepository
extends ExcelbasiertesRepository<Erf\u00fcllungsweg>
implements Erf\u00fcllungswegRepository {
    private final ArbeitsschrittRepository arbeitsschritte;

    public ExcelbasiertesErf\u00fcllungswegRepository(File datei, ExcelLader excel, ArbeitsschrittRepository arbeitsschritte) throws IOException {
        super(datei, excel, 0);
        this.arbeitsschritte = arbeitsschritte;
    }

    public Iterable<Erf\u00fcllungsweg> alle() {
        ArrayList<Erf\u00fcllungsweg> result = new ArrayList<Erf\u00fcllungsweg>();
        this.interpretiert(this.zeilenAus("Lineare_Erf\u00fcllungswege"), 3, this::alsLinearerErf\u00fcllungsweg).forEach(result::add);
        ParallelenErf\u00fcllungswegEinlesen paralleleWege = new ParallelenErf\u00fcllungswegEinlesen(this.arbeitsschritte);
        Iterable definitionen = this.tabellenMitEigenschaft(paralleleWege::istErf\u00fcllungswegdefinition);
        for (Exceldatei.Exceltabelle each : definitionen) {
            paralleleWege.aus(each).ifPresent(result::add);
        }
        return result;
    }

    private Optional<Erf\u00fcllungsweg> alsLinearerErf\u00fcllungsweg(Exceldatei.Excelzeile zeile) {
        String identifier = zeile.stringIn("C");
        if (identifier.isBlank()) {
            return Optional.empty();
        }
        String beschaffungskategorie = zeile.stringIn("D");
        String langschl\u00fcssel = zeile.stringIn("E");
        String beschreibung = zeile.stringIn("F");
        ArrayList<Arbeitsschritt> t\u00e4tigkeiten = new ArrayList<Arbeitsschritt>();
        int start = Exceldatei.Excelzeile.spaltenindexF\u00fcr((String)"H");
        int ende = Exceldatei.Excelzeile.spaltenindexF\u00fcr((String)"U");
        for (int i = start; i <= ende; ++i) {
            String arbeitsschritt = zeile.stringIn(i);
            if (arbeitsschritt.isBlank()) continue;
            Optional maybeSchritt = this.arbeitsschritte.f\u00fcrIdentifierOderT\u00e4tigkeit(arbeitsschritt);
            if (maybeSchritt.isEmpty()) {
                this.getLogger().error((Object)("Kann den Arbeitsschritt " + arbeitsschritt + " nicht aufl\u00f6sen."));
                continue;
            }
            t\u00e4tigkeiten.add((Arbeitsschritt)maybeSchritt.get());
        }
        Erf\u00fcllungsweg result = new Erf\u00fcllungsweg(identifier, beschaffungskategorie, langschl\u00fcssel, beschreibung, Erf\u00fcllungsschritt.direkteSchrittfolgeAus(t\u00e4tigkeiten, (char)'H', (String)zeile.name()));
        return Optional.of(result);
    }
}

