/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.model.repository.filebased.excel;

import com.schneide.base.logging.LoggedObject;
import com.schneide.base.text.transformation.Without;
import com.schneide.werp.domain.erf\u00fcllung.schritt.Arbeitsschritt;
import com.schneide.werp.domain.erf\u00fcllung.schritt.ArbeitsschrittRepository;
import com.schneide.werp.domain.format.excel.Exceldatei;
import com.schneide.werp.model.repository.excelbased.ExcelbasiertesRepository;
import com.schneide.werp.periphery.datenimport.lader.ExcelLader;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Optional;

public class ExcelbasiertesArbeitsschrittRepository
extends ExcelbasiertesRepository<Arbeitsschritt>
implements ArbeitsschrittRepository {
    public ExcelbasiertesArbeitsschrittRepository(File datei, ExcelLader excel) throws IOException {
        super(datei, excel, 9);
    }

    public Iterable<Arbeitsschritt> alle() {
        return this.interpretiert(this.zeilenAus("T\u00e4tigkeiten"), this::alsArbeitsschritt);
    }

    private Optional<Arbeitsschritt> alsArbeitsschritt(Exceldatei.Excelzeile zeile) {
        String nummer = zeile.stringIn("A");
        String t\u00e4tigkeit = zeile.stringIn("B");
        if (t\u00e4tigkeit.isBlank()) {
            return Optional.empty();
        }
        String beschreibung = zeile.stringIn("C");
        boolean istVorziehbar = "ja".equalsIgnoreCase(zeile.stringIn("D"));
        Optional<Arbeitsschritt.Bedingung> bedingung = ExcelbasiertesArbeitsschrittRepository.bedingungAus(zeile.stringIn("E"));
        Arbeitsschritt result = new Arbeitsschritt(nummer, Without.lineBreaks((String)t\u00e4tigkeit), Collections.emptyList(), istVorziehbar, beschreibung, bedingung);
        return Optional.of(result);
    }

    protected static Optional<Arbeitsschritt.Bedingung> bedingungAus(String text) {
        if (text == null || text.isBlank()) {
            return Optional.empty();
        }
        String[] parts = text.split("=");
        if (parts.length != 2) {
            LoggedObject.getStaticLogger().warn((Object)("Die gegebene Bedingung " + text + " wurde nicht korrekt erkannt."));
            return Optional.empty();
        }
        String eigenschaft = parts[0].trim();
        String wert = parts[1].trim();
        return Optional.of(new Arbeitsschritt.Bedingung(eigenschaft, wert));
    }
}

