/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.model.repository.cache;

import com.schneide.base.logging.LoggedObject;
import com.schneide.werp.domain.artikel.Artikel;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.store.storage.embedded.types.EmbeddedStorageManager;

public class ArtikelCache
extends LoggedObject {
    private final Map<String, Artikel<?>> cache = new HashMap();
    private final List<Artikel<?>> sortierterCache = new LinkedList();

    public void storeWith(EmbeddedStorageManager cacheStorage) {
        cacheStorage.store(this.cache);
        cacheStorage.store(this.sortierterCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<Artikel<?>> alle() {
        Map<String, Artikel<?>> map = this.cache;
        synchronized (map) {
            return Collections.unmodifiableList(this.sortierterCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Artikel<?>> f\u00fcrRevisionierteArtikelnummer(String revisionierteArtikelnummer) {
        Map<String, Artikel<?>> map = this.cache;
        synchronized (map) {
            return Optional.ofNullable(this.cache.get(revisionierteArtikelnummer));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int anzahl() {
        Map<String, Artikel<?>> map = this.cache;
        synchronized (map) {
            return this.cache.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Artikel<?>> anIndex(int index) {
        Map<String, Artikel<?>> map = this.cache;
        synchronized (map) {
            try {
                return Optional.ofNullable(this.sortierterCache.get(index));
            }
            catch (IndexOutOfBoundsException e) {
                this.getLogger().warn((Object)"Ung\u00fcltiger Index f\u00fcr Artikel angefragt.", (Throwable)e);
                return Optional.empty();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void speichere(Artikel<?> artikel) {
        Map<String, Artikel<?>> map = this.cache;
        synchronized (map) {
            Artikel<?> previous = this.cache.put(artikel.revisionierteArtikelnummer(), artikel);
            if (previous != null) {
                this.sortierterCache.remove(previous);
            }
            this.sortierterCache.add(artikel);
            Collections.sort(this.sortierterCache, Artikel.alphabetischNachArtikelnummer());
        }
    }
}

