/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.gui.main;

import com.schneide.base.eventbus.EventBus;
import com.schneide.base.eventbus.util.Subscriber;
import com.schneide.base.gui.component.generic.UIComponent;
import com.schneide.base.gui.swing.EDT;
import com.schneide.werp.domain.erf\u00fcllung.schritt.Arbeitsschritt;
import com.schneide.werp.domain.produktion.Produktionsnummer;
import com.schneide.werp.domain.session.WerpSession;
import com.schneide.werp.periphery.dokumenterstellung.Dokumenterstellung;
import com.schneide.werp.produktion.domain.arbeitsauftrag.Arbeitsauftragdaten;
import com.schneide.werp.produktion.engine.arbeitsauftrag.news.ArbeitsauftragdatenAnzeigen;
import com.schneide.werp.produktion.engine.dashboard.news.DashboardAnzeigen;
import com.schneide.werp.produktion.engine.eingrenzung.Arbeitsauftragsuchtexteingrenzung;
import com.schneide.werp.produktion.engine.eingrenzung.generic.Dateneingrenzung;
import com.schneide.werp.produktion.gui.entities.arbeitsauftrag.ArbeitsauftragDashboard;
import com.schneide.werp.produktion.gui.entities.arbeitsauftrag.Arbeitsauftragseingrenzunganzeige;
import com.schneide.werp.produktion.gui.entities.arbeitsauftrag.ErgebnisAlsPDF;
import com.schneide.werp.produktion.gui.entities.arbeitsauftrag.Produktionseingrenzunganzeige;
import com.schneide.werp.produktion.gui.entities.arbeitsauftrag.Typeingrenzunganzeige;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class Hauptbereich
extends UIComponent<JPanel> {
    private final WerpSession session;
    private final Iterable<Dateneingrenzung<Arbeitsauftragdaten>> eingrenzungen;
    private final JPanel inhaltsbereich;
    private final Subscriber<DashboardAnzeigen> boardanzeige;
    private final Subscriber<ArbeitsauftragdatenAnzeigen> datenanzeige;
    private final Produktionseingrenzunganzeige produktioneingrenzung;
    private final Arbeitsauftragseingrenzunganzeige suchtexteingrenzung;
    private final Typeingrenzunganzeige typeingrenzung;
    private final ErgebnisAlsPDF export;
    private Optional<ArbeitsauftragDashboard> aktuellesDashboard;

    public Hauptbereich(Supplier<Dokumenterstellung> erstellung, Supplier<Stream<Produktionsnummer>> existierendeProduktionen, Supplier<Iterable<Arbeitsschritt>> alleT\u00e4tigkeiten, WerpSession session) {
        this.session = session;
        this.produktioneingrenzung = new Produktionseingrenzunganzeige(existierendeProduktionen, this::datenNeuLaden);
        ArrayList<Dateneingrenzung<Arbeitsauftragdaten>> neueEingrenzungen = new ArrayList<Dateneingrenzung<Arbeitsauftragdaten>>();
        this.suchtexteingrenzung = new Arbeitsauftragseingrenzunganzeige(new Arbeitsauftragsuchtexteingrenzung(), this::datenNeuLaden);
        neueEingrenzungen.add(this.suchtexteingrenzung);
        this.typeingrenzung = new Typeingrenzunganzeige(alleT\u00e4tigkeiten, this::datenNeuLaden);
        neueEingrenzungen.add(this.typeingrenzung);
        this.inhaltsbereich = (JPanel)EDT.query(() -> {
            JPanel result = new JPanel();
            result.setLayout((LayoutManager)new MigLayout("ins 0", "grow, fill, push", "grow, fill, push"));
            return result;
        });
        this.boardanzeige = new Subscriber(DashboardAnzeigen.class, n -> this.anzeigen(n.dashboard()));
        this.datenanzeige = new Subscriber(ArbeitsauftragdatenAnzeigen.class, n -> this.anzeigen(n.auftragsdaten()));
        this.aktuellesDashboard = Optional.empty();
        this.eingrenzungen = neueEingrenzungen;
        this.export = new ErgebnisAlsPDF(() -> this.aktuellesDashboard, erstellung, session);
    }

    public void requestFocus() {
        this.suchtexteingrenzung.requestFocus();
    }

    protected void anzeigen(ArbeitsauftragDashboard dashboard) {
        this.aktuellesDashboard.ifPresent(ArbeitsauftragDashboard::wirdNichtMehrAngezeigt);
        this.zeigeAn(dashboard);
        this.datenNeuLaden();
    }

    protected void datenNeuLaden() {
        this.aktuellesDashboard.ifPresent(ad -> ad.wirdAngezeigt(arg_0 -> this.boardanzeige.publishIfSubscribed(arg_0), this.produktioneingrenzung.gew\u00e4hlteProduktionen()));
    }

    protected void anzeigen(Iterable<Arbeitsauftragdaten> auftragsdaten) {
        this.aktuellesDashboard.ifPresent(ad -> ad.anzeigen(this.grenzeVollst\u00e4ndigEin(auftragsdaten)));
    }

    protected Iterable<Arbeitsauftragdaten> grenzeVollst\u00e4ndigEin(Iterable<Arbeitsauftragdaten> daten) {
        Iterable<Arbeitsauftragdaten> aktuell = daten;
        for (Dateneingrenzung<Arbeitsauftragdaten> each : this.eingrenzungen) {
            aktuell = each.grenzeEin(aktuell);
        }
        return aktuell;
    }

    public void lauscheAuf(EventBus applicationBus) {
        Subscriber.attach(this.boardanzeige, (EventBus)applicationBus);
        Subscriber.attach(this.datenanzeige, (EventBus)applicationBus);
    }

    public void zeigeAn(ArbeitsauftragDashboard dashboard) {
        EDT.performBlocking(() -> {
            this.inhaltsbereich.removeAll();
            this.inhaltsbereich.add(dashboard.prepare());
            this.inhaltsbereich.revalidate();
        });
        this.aktuellesDashboard = Optional.ofNullable(dashboard);
    }

    protected JPanel buildComponent() {
        JPanel result = new JPanel();
        result.setLayout(new BorderLayout(0, 0));
        JPanel header = new JPanel();
        header.setLayout((LayoutManager)new MigLayout("ins 0", "[][][][grow][right]", "[fill, align bottom]"));
        header.add(this.produktioneingrenzung.prepare());
        header.add(this.suchtexteingrenzung.prepare());
        header.add(this.typeingrenzung.prepare());
        header.add(this.export.prepare());
        header.add(new JPanel());
        result.add((Component)header, "North");
        result.add((Component)this.inhaltsbereich, "Center");
        return result;
    }
}

