/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.gui.frame;

import com.schneide.base.datatypes.collections.iterable.IterableUtil;
import com.schneide.werp.domain.projekt.Projekt;
import com.schneide.werp.domain.projekt.ProjektRepository;
import com.schneide.werp.domain.session.WerpSession;
import com.schneide.werp.gui.frame.generic.WerpFrame;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class ProjektverwaltungFrame
extends WerpFrame {
    private final ProjektRepository projekte;

    public ProjektverwaltungFrame(WerpSession session, ProjektRepository projekte) {
        super(session, "Projekte verwalten");
        this.projekte = projekte;
    }

    protected void buildUIFor(JFrame frame) {
        Projektdaten projektdaten = new Projektdaten(this.projekte);
        JTable projekttabelle = new JTable(projektdaten);
        JScrollPane scrolling = new JScrollPane(projekttabelle);
        frame.getContentPane().add(scrolling);
    }

    public static final class Projektdaten
    extends AbstractTableModel {
        private static final long serialVersionUID = -2942460779120915795L;
        private static final String fehlerindikator = "FEHLER!";
        private final ProjektRepository repository;
        private final Map<Integer, String> spaltentitel;
        private final Map<Integer, Function<Projekt, Object>> zellendaten;

        public Projektdaten(ProjektRepository repository) {
            this.repository = repository;
            this.spaltentitel = new HashMap<Integer, String>();
            this.zellendaten = new HashMap<Integer, Function<Projekt, Object>>();
            List<Tabellenspalte> spalten = List.of(new Tabellenspalte(0, "Projektnummer", p -> p.nummer().alsText()), new Tabellenspalte(1, "Beschreibung", Projekt::beschreibung), new Tabellenspalte(2, "Anzahl Positionen", p -> IterableUtil.getSizeFor((Iterable)p.st\u00fccklisteneintr\u00e4ge())));
            spalten.forEach(s -> {
                this.spaltentitel.put(s.index(), s.titel());
                this.zellendaten.put(s.index(), s.datenextraktion());
            });
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.spaltentitel.getOrDefault(columnIndex, fehlerindikator);
        }

        @Override
        public int getColumnCount() {
            return this.zellendaten.size();
        }

        @Override
        public int getRowCount() {
            return this.repository.anzahl();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Optional maybeProjekt = this.repository.anIndex(rowIndex);
            return maybeProjekt.map(this.zellendaten.get(columnIndex)::apply).orElseGet(() -> fehlerindikator);
        }
    }

    private record Tabellenspalte(int index, String titel, Function<Projekt, Object> datenextraktion) {
    }
}

