/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.gui.frame;

import com.schneide.base.datatypes.collections.iterable.IterableUtil;
import com.schneide.werp.domain.erf\u00fcllung.weg.Erf\u00fcllungsweg;
import com.schneide.werp.domain.erf\u00fcllung.weg.Erf\u00fcllungswegRepository;
import com.schneide.werp.domain.session.WerpSession;
import com.schneide.werp.gui.frame.generic.WerpFrame;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class Erf\u00fcllungswegverwaltungFrame
extends WerpFrame {
    private final Erf\u00fcllungswegRepository entities;

    public Erf\u00fcllungswegverwaltungFrame(WerpSession session, Erf\u00fcllungswegRepository entities) {
        super(session, "Erf\u00fcllungsweg verwalten");
        this.entities = entities;
    }

    protected void buildUIFor(JFrame frame) {
        Erf\u00fcllungswegdaten tabellendaten = new Erf\u00fcllungswegdaten(this.entities);
        JTable datentabelle = new JTable(tabellendaten);
        JScrollPane scrolling = new JScrollPane(datentabelle);
        frame.getContentPane().add(scrolling);
    }

    public static final class Erf\u00fcllungswegdaten
    extends AbstractTableModel {
        private static final long serialVersionUID = -2942460779120915795L;
        private static final String fehlerindikator = "FEHLER!";
        private final Erf\u00fcllungswegRepository repository;
        private final Map<Integer, String> spaltentitel;
        private final Map<Integer, Function<Erf\u00fcllungsweg, Object>> zellendaten;

        public Erf\u00fcllungswegdaten(Erf\u00fcllungswegRepository repository) {
            this.repository = repository;
            this.spaltentitel = new HashMap<Integer, String>();
            this.zellendaten = new HashMap<Integer, Function<Erf\u00fcllungsweg, Object>>();
            List<Tabellenspalte> spalten = List.of(new Tabellenspalte(0, "Identifikation", a -> a.identifier()), new Tabellenspalte(1, "Beschreibung", a -> a.beschreibung()), new Tabellenspalte(2, "Anzahl Arbeitsschritte", a -> IterableUtil.getSizeFor((Iterable)a.schritteAlsIdentifier())), new Tabellenspalte(3, "Beschaffungskategorie", a -> a.beschaffungskategorie()), new Tabellenspalte(4, "Langschl\u00fcssel", a -> a.langschl\u00fcssel()));
            spalten.forEach(s -> {
                this.spaltentitel.put(s.index(), s.titel());
                this.zellendaten.put(s.index(), s.datenextraktion());
            });
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.spaltentitel.getOrDefault(columnIndex, fehlerindikator);
        }

        @Override
        public int getColumnCount() {
            return this.zellendaten.size();
        }

        @Override
        public int getRowCount() {
            return this.repository.anzahl();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Optional maybeEntity = this.repository.anIndex(rowIndex);
            return maybeEntity.map(this.zellendaten.get(columnIndex)::apply).orElseGet(() -> fehlerindikator);
        }
    }

    private record Tabellenspalte(int index, String titel, Function<Erf\u00fcllungsweg, Object> datenextraktion) {
    }
}

