/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.gui.frame;

import com.schneide.base.datatypes.collections.iterable.IterableUtil;
import com.schneide.base.gui.swing.EDT;
import com.schneide.werp.domain.artikel.Artikel;
import com.schneide.werp.domain.artikel.ArtikelRepository;
import com.schneide.werp.domain.session.WerpSession;
import com.schneide.werp.gui.frame.generic.WerpFrame;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class ArtikelverwaltungFrame
extends WerpFrame {
    private final ArtikelRepository artikel;

    public ArtikelverwaltungFrame(WerpSession session, ArtikelRepository artikel) {
        super(session, "Artikel verwalten");
        this.artikel = artikel;
    }

    protected void buildUIFor(JFrame frame) {
        final Artikeldaten artikeldaten = new Artikeldaten(this.artikel);
        final JTable artikeltabelle = new JTable(artikeldaten);
        artikeltabelle.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Point point = e.getPoint();
                int row = artikeltabelle.rowAtPoint(point);
                if (row != -1 && e.getClickCount() == 2 && artikeltabelle.getSelectedRow() != -1) {
                    Optional<Artikel<?>> maybeArtikel = artikeldaten.getArtikelAt(row);
                    ArtikelverwaltungFrame.this.onDoubleClickOf(maybeArtikel);
                }
            }
        });
        JScrollPane scrolling = new JScrollPane(artikeltabelle);
        frame.getContentPane().add(scrolling);
    }

    protected void onDoubleClickOf(Optional<Artikel<?>> maybeArtikel) {
        EDT.always();
        if (maybeArtikel.isEmpty()) {
            return;
        }
        Artikel<?> gew\u00e4hlt = maybeArtikel.get();
        System.out.println("Zeige Edit f\u00fcr " + String.valueOf(gew\u00e4hlt));
    }

    public static final class Artikeldaten
    extends AbstractTableModel {
        private static final long serialVersionUID = -2942460779120915795L;
        private static final String fehlerindikator = "FEHLER!";
        private final ArtikelRepository repository;
        private final Map<Integer, String> spaltentitel;
        private final Map<Integer, Function<Artikel<?>, Object>> zellendaten;

        public Artikeldaten(ArtikelRepository repository) {
            this.repository = repository;
            this.spaltentitel = new HashMap<Integer, String>();
            this.zellendaten = new HashMap();
            List<Tabellenspalte> spalten = List.of(new Tabellenspalte(0, "Artikelnummer", a -> a.artikelnummer().alsText()), new Tabellenspalte(1, "Bezeichnung", a -> a.bezeichnung()), new Tabellenspalte(2, "Baugruppe", a -> a.istBaugruppe() ? "Baugruppe" : "Einzelteil"), new Tabellenspalte(2, "Erf\u00fcllungsweg", a -> a.erf\u00fcllungsweg()), new Tabellenspalte(3, "Revision", a -> a.revision().alsText()), new Tabellenspalte(4, "St\u00fccklisteneintr\u00e4ge", a -> IterableUtil.getSizeFor((Iterable)a.st\u00fccklisteneintr\u00e4ge())));
            spalten.forEach(s -> {
                this.spaltentitel.put(s.index(), s.titel());
                this.zellendaten.put(s.index(), s.datenextraktion());
            });
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.spaltentitel.getOrDefault(columnIndex, fehlerindikator);
        }

        @Override
        public int getColumnCount() {
            return this.zellendaten.size();
        }

        @Override
        public int getRowCount() {
            return this.repository.anzahl();
        }

        public Optional<Artikel<?>> getArtikelAt(int rowIndex) {
            return this.repository.anIndex(rowIndex);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.getArtikelAt(rowIndex).map(this.zellendaten.get(columnIndex)::apply).orElseGet(() -> fehlerindikator);
        }
    }

    private record Tabellenspalte(int index, String titel, Function<Artikel<?>, Object> datenextraktion) {
    }
}

