/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.gui.frame;

import com.schneide.werp.domain.erf\u00fcllung.schritt.Arbeitsschritt;
import com.schneide.werp.domain.erf\u00fcllung.schritt.ArbeitsschrittRepository;
import com.schneide.werp.domain.session.WerpSession;
import com.schneide.werp.gui.frame.generic.WerpFrame;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class ArbeitsschrittverwaltungFrame
extends WerpFrame {
    private final ArbeitsschrittRepository entities;

    public ArbeitsschrittverwaltungFrame(WerpSession session, ArbeitsschrittRepository entities) {
        super(session, "Arbeitsschritt verwalten");
        this.entities = entities;
    }

    protected void buildUIFor(JFrame frame) {
        Arbeitsschrittdaten tabellendaten = new Arbeitsschrittdaten(this.entities);
        JTable datentabelle = new JTable(tabellendaten);
        JScrollPane scrolling = new JScrollPane(datentabelle);
        frame.getContentPane().add(scrolling);
    }

    public static final class Arbeitsschrittdaten
    extends AbstractTableModel {
        private static final long serialVersionUID = -2942460779120915795L;
        private static final String fehlerindikator = "FEHLER!";
        private final ArbeitsschrittRepository repository;
        private final Map<Integer, String> spaltentitel;
        private final Map<Integer, Function<Arbeitsschritt, Object>> zellendaten;

        public Arbeitsschrittdaten(ArbeitsschrittRepository repository) {
            this.repository = repository;
            this.spaltentitel = new HashMap<Integer, String>();
            this.zellendaten = new HashMap<Integer, Function<Arbeitsschritt, Object>>();
            List<Tabellenspalte> spalten = List.of(new Tabellenspalte(0, "Nummer", a -> a.nummer()), new Tabellenspalte(1, "T\u00e4tigkeit", a -> a.t\u00e4tigkeit()), new Tabellenspalte(2, "Beschreibung", a -> a.beschreibung()), new Tabellenspalte(3, "Bedingung", a -> a.bedingungsbeschreibung()), new Tabellenspalte(4, "Vorziehbar", a -> a.istVorziehbar() ? "Ja" : "Nein"));
            spalten.forEach(s -> {
                this.spaltentitel.put(s.index(), s.titel());
                this.zellendaten.put(s.index(), s.datenextraktion());
            });
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.spaltentitel.getOrDefault(columnIndex, fehlerindikator);
        }

        @Override
        public int getColumnCount() {
            return this.zellendaten.size();
        }

        @Override
        public int getRowCount() {
            return this.repository.anzahl();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Optional maybeEntity = this.repository.anIndex(rowIndex);
            return maybeEntity.map(this.zellendaten.get(columnIndex)::apply).orElseGet(() -> fehlerindikator);
        }
    }

    private record Tabellenspalte(int index, String titel, Function<Arbeitsschritt, Object> datenextraktion) {
    }
}

