/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.gui.entities.arbeitsauftrag;

import com.schneide.base.datatypes.collections.iterable.FilteredIterable;
import com.schneide.base.datatypes.collections.iterable.IterableUtil;
import com.schneide.base.datatypes.collections.iterable.TransformingIterable;
import com.schneide.base.gui.component.generic.UIComponent;
import com.schneide.base.gui.swing.EDT;
import com.schneide.base.threading.executor.DoInBackground;
import com.schneide.werp.domain.erf\u00fcllung.schritt.Arbeitsschritt;
import com.schneide.werp.engine.eingrenzung.BooleanEingrenzung;
import com.schneide.werp.gui.widget.generic.MultiComboBox;
import com.schneide.werp.gui.widget.generic.RoundedBorder;
import com.schneide.werp.produktion.domain.arbeitsauftrag.Arbeitsauftragdaten;
import com.schneide.werp.produktion.engine.eingrenzung.generic.Dateneingrenzung;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Vector;
import java.util.function.Supplier;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;

public class Typeingrenzunganzeige
extends UIComponent<JPanel>
implements Dateneingrenzung<Arbeitsauftragdaten> {
    private final MultiComboBox<SelectableArbeitsschritt> gewollteT\u00e4tigkeiten;
    private final Iterable<Eingrenzungsschaltfl\u00e4che> eingrenzungen;
    private final Runnable neuLaden;
    private final Supplier<Iterable<Arbeitsschritt>> alleT\u00e4tigkeiten;

    public Typeingrenzunganzeige(Supplier<Iterable<Arbeitsschritt>> alleT\u00e4tigkeiten, Runnable neuLaden) {
        this.alleT\u00e4tigkeiten = alleT\u00e4tigkeiten;
        this.neuLaden = neuLaden;
        this.gewollteT\u00e4tigkeiten = (MultiComboBox)EDT.query(() -> {
            Vector entries = new Vector();
            ((Iterable)alleT\u00e4tigkeiten.get()).forEach(as -> entries.add(new SelectableArbeitsschritt((Arbeitsschritt)as)));
            MultiComboBox result = new MultiComboBox(new DefaultComboBoxModel(entries), 30);
            result.setMinimumSize(new Dimension(300, -1));
            return result;
        });
        ArrayList<Eingrenzungsschaltfl\u00e4che> schaltfl\u00e4chen = new ArrayList<Eingrenzungsschaltfl\u00e4che>();
        List.of(new BooleanEingrenzung("Nur Unerledigte", (a, t) -> !a.istFertiggestellt()), new BooleanEingrenzung("Nur Unblockierte", (a, t) -> a.alleVorarbeitenSindErf\u00fcllt()), new BooleanEingrenzung("Nur Vorziehbar", (a, t) -> a.auftrag().t\u00e4tigkeit().istVorziehbar())).forEach(each -> {
            Eingrenzungsschaltfl\u00e4che schaltfl\u00e4che = (Eingrenzungsschaltfl\u00e4che)EDT.query(() -> new Eingrenzungsschaltfl\u00e4che((BooleanEingrenzung<Arbeitsauftragdaten>)each));
            schaltfl\u00e4chen.add(schaltfl\u00e4che);
        });
        this.eingrenzungen = schaltfl\u00e4chen;
    }

    public void requestFocus() {
        EDT.perform(() -> this.gewollteT\u00e4tigkeiten.requestFocusInWindow());
    }

    private void suchlaufDurchf\u00fchren() {
        DoInBackground.now((String)"Suche", (Runnable)this.neuLaden);
    }

    protected JPanel buildComponent() {
        JPanel result = new JPanel();
        result.setLayout((LayoutManager)new MigLayout("", "[]2px[]2px[]10px[]2px[]2px[]2px[]2px[]2px[]2px[]", ""));
        result.add((Component)new JLabel("Nur Arbeitsschritte:"), "wrap");
        result.add((Component)this.gewollteT\u00e4tigkeiten, "");
        ActionListener suchlaufDurchf\u00fchren = e -> this.suchlaufDurchf\u00fchren();
        this.gewollteT\u00e4tigkeiten.addActionListener(suchlaufDurchf\u00fchren);
        for (Eingrenzungsschaltfl\u00e4che each : this.eingrenzungen) {
            each.addActionListener(suchlaufDurchf\u00fchren);
            result.add((Component)each, "");
        }
        result.setBorder((Border)new RoundedBorder(Color.black, 10));
        return result;
    }

    @Override
    public Iterable<Arbeitsauftragdaten> grenzeEin(Iterable<Arbeitsauftragdaten> auftragsdaten) {
        Iterable t\u00e4tigkeiten = (Iterable)EDT.query(() -> {
            Iterable gew\u00e4hlteT\u00e4tigkeiten = this.gewollteT\u00e4tigkeiten.getSelectedItems();
            if (IterableUtil.isEmpty((Iterable)gew\u00e4hlteT\u00e4tigkeiten)) {
                return this.alleT\u00e4tigkeiten.get();
            }
            return new TransformingIterable(SelectableArbeitsschritt::t\u00e4tigkeit, gew\u00e4hlteT\u00e4tigkeiten);
        });
        Set erlaubteT\u00e4tigkeiten = IterableUtil.asSet((Iterable)t\u00e4tigkeiten);
        List aktiveBedingungen = (List)EDT.query(() -> {
            ArrayList result = new ArrayList();
            this.eingrenzungen.forEach(es -> es.verhalten().ifPresent(result::add));
            return result;
        });
        return new FilteredIterable(auftragsdaten, a -> this.wirdDurchgelassen((Arbeitsauftragdaten)a, erlaubteT\u00e4tigkeiten, aktiveBedingungen));
    }

    protected boolean wirdDurchgelassen(Arbeitsauftragdaten auftrag, Set<Arbeitsschritt> erlaubt, Iterable<BooleanEingrenzung<Arbeitsauftragdaten>> bedingungen) {
        if (!erlaubt.contains(auftrag.auftrag().t\u00e4tigkeit())) {
            return false;
        }
        for (BooleanEingrenzung<Arbeitsauftragdaten> each : bedingungen) {
            if (each.durchlassen((Object)auftrag, Boolean.valueOf(true))) continue;
            return false;
        }
        return true;
    }

    protected Iterable<BooleanEingrenzung<Arbeitsauftragdaten>> aktiveEingrenzungen() {
        ArrayList<BooleanEingrenzung<Arbeitsauftragdaten>> result = new ArrayList<BooleanEingrenzung<Arbeitsauftragdaten>>();
        for (Eingrenzungsschaltfl\u00e4che each : this.eingrenzungen) {
            each.verhalten().ifPresent(result::add);
        }
        return result;
    }

    protected static class Eingrenzungsschaltfl\u00e4che
    extends JToggleButton {
        private static final long serialVersionUID = 3172816216679944423L;
        private final BooleanEingrenzung<Arbeitsauftragdaten> verhalten;

        public Eingrenzungsschaltfl\u00e4che(BooleanEingrenzung<Arbeitsauftragdaten> verhalten) {
            super(verhalten.bezeichnung());
            this.verhalten = verhalten;
            this.setSelected(false);
        }

        public Optional<BooleanEingrenzung<Arbeitsauftragdaten>> verhalten() {
            boolean aktiv = (Boolean)EDT.query(this::isSelected);
            return aktiv ? Optional.of(this.verhalten) : Optional.empty();
        }
    }

    private static class SelectableArbeitsschritt
    extends MultiComboBox.CheckableItem {
        private final Arbeitsschritt t\u00e4tigkeit;

        public SelectableArbeitsschritt(Arbeitsschritt t\u00e4tigkeit) {
            super(t\u00e4tigkeit.nummerMitT\u00e4tigkeit(), false);
            this.t\u00e4tigkeit = t\u00e4tigkeit;
        }

        public String abbreviation() {
            return this.t\u00e4tigkeit.nummer();
        }

        public Arbeitsschritt t\u00e4tigkeit() {
            return this.t\u00e4tigkeit;
        }
    }
}

