/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.gui.entities.arbeitsauftrag;

import com.schneide.base.datatypes.collections.iterable.IterableUtil;
import com.schneide.base.datatypes.collections.iterable.TransformingIterable;
import com.schneide.base.gui.component.generic.UIComponent;
import com.schneide.base.gui.dialog.defaults.DefaultDialog;
import com.schneide.base.gui.icon.LoadedIcon;
import com.schneide.base.gui.model.WindowStack;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.werp.domain.publishing.Report;
import com.schneide.werp.domain.session.WerpSession;
import com.schneide.werp.gui.component.AuswahlEinerDatei;
import com.schneide.werp.gui.widget.generic.RoundedBorder;
import com.schneide.werp.periphery.dokumenterstellung.Dokumenterstellung;
import com.schneide.werp.produktion.gui.entities.arbeitsauftrag.ArbeitsauftragDashboard;
import com.schneide.werp.produktion.output.Arbeitsauftr\u00e4geAlsPDF;
import java.awt.Color;
import java.awt.LayoutManager;
import java.io.File;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Supplier;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;

public class ErgebnisAlsPDF
extends UIComponent<JPanel> {
    private final LoadedIcon pdfSymbol = new LoadedIcon("resources/images/icons/pdf-file_32px.png");
    private final Supplier<Optional<ArbeitsauftragDashboard>> aktuellesDashboard;
    private final Supplier<Dokumenterstellung> erstellung;
    private final WerpSession session;

    public ErgebnisAlsPDF(Supplier<Optional<ArbeitsauftragDashboard>> aktuellesDashboard, Supplier<Dokumenterstellung> erstellung, WerpSession session) {
        this.aktuellesDashboard = aktuellesDashboard;
        this.erstellung = erstellung;
        this.session = session;
    }

    protected JPanel buildComponent() {
        JPanel result = new JPanel();
        result.setLayout((LayoutManager)new MigLayout("", "", ""));
        JButton exportieren = new JButton(this.pdfSymbol.icon());
        exportieren.setToolTipText("Suchergebnis als PDF-Dokument exportieren");
        exportieren.addActionListener(e -> this.exportDurchf\u00fchren());
        result.add(exportieren);
        result.setBorder((Border)new RoundedBorder(Color.black, 10));
        return result;
    }

    protected void exportDurchf\u00fchren() {
        Iterable zuExportieren = this.aktuellesDashboard.get().map(ArbeitsauftragDashboard::zuletztAngezeigt).orElseGet(Collections::emptyList);
        if (IterableUtil.isEmpty((Iterable)zuExportieren)) {
            DefaultDialog.showInformationDialog((WindowStack)this.session.getMainWindowStack(), (String)"Keine Arbeitsauftr\u00e4ge", (String)"Es liegen keine Arbeitsauftr\u00e4ge zum Exportieren vor.");
            return;
        }
        String gew\u00fcnschteEndung = "pdf";
        AuswahlEinerDatei speicherort = new AuswahlEinerDatei(new File(System.getProperty("user.home") + "/Desktop"), "PDF-Dokument", new String[]{"pdf"});
        Optional maybeZieldatei = speicherort.selectFile(this.session);
        if (maybeZieldatei.isEmpty()) {
            this.getLogger().info((Object)"Keine Zieldatei ausgew\u00e4hlt.");
            return;
        }
        VirtualFile zieldatei = ((VirtualFile)maybeZieldatei.get()).withOtherExtension("pdf");
        Dokumenterstellung.speichereIn((Report)new Arbeitsauftr\u00e4geAlsPDF().f\u00fcr(zieldatei.nameWithoutExtension(), (Iterable<Arbeitsauftr\u00e4geAlsPDF.Ausdruckangaben>)new TransformingIterable(Arbeitsauftr\u00e4geAlsPDF.Ausdruckangaben::f\u00fcr, zuExportieren)), (VirtualFile)zieldatei, (Dokumenterstellung)this.erstellung.get());
        DefaultDialog.showInformationDialog((WindowStack)this.session.getMainWindowStack(), (String)"PDF-Dokument erstellt", (String)("Die aktuell gefundenen Arbeitsauftr\u00e4ge sind in die Datei " + zieldatei.getName() + " exportiert."));
    }
}

