/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.gui.entities.arbeitsauftrag;

import com.schneide.base.gui.component.generic.UIComponent;
import com.schneide.base.gui.swing.EDT;
import com.schneide.base.threading.executor.DoInBackground;
import com.schneide.werp.engine.eingrenzung.TextEingrenzung;
import com.schneide.werp.gui.widget.generic.MultiComboBox;
import com.schneide.werp.gui.widget.generic.RoundedBorder;
import com.schneide.werp.produktion.domain.arbeitsauftrag.Arbeitsauftragdaten;
import com.schneide.werp.produktion.engine.eingrenzung.Arbeitsauftragsuchtexteingrenzung;
import com.schneide.werp.produktion.engine.eingrenzung.generic.Dateneingrenzung;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;

public class Arbeitsauftragseingrenzunganzeige
extends UIComponent<JPanel>
implements Dateneingrenzung<Arbeitsauftragdaten> {
    private final Arbeitsauftragsuchtexteingrenzung engine;
    private final JTextField suchtext;
    private final Iterable<Eingrenzungsoption> eingrenzungen;
    private final Runnable neuLaden;

    public Arbeitsauftragseingrenzunganzeige(Arbeitsauftragsuchtexteingrenzung eingrenzung, Runnable neuLaden) {
        this.engine = eingrenzung;
        this.neuLaden = neuLaden;
        this.suchtext = (JTextField)EDT.query(JTextField::new);
        ArrayList<Eingrenzungsoption> schaltfl\u00e4chen = new ArrayList<Eingrenzungsoption>();
        eingrenzung.verf\u00fcgbareEingrenzungen().forEach(each -> {
            Eingrenzungsoption schaltfl\u00e4che = (Eingrenzungsoption)((Object)((Object)EDT.query(() -> new Eingrenzungsoption((TextEingrenzung<Arbeitsauftragdaten>)each))));
            schaltfl\u00e4chen.add(schaltfl\u00e4che);
        });
        this.eingrenzungen = schaltfl\u00e4chen;
    }

    public void requestFocus() {
        EDT.perform(() -> this.suchtext.requestFocusInWindow());
    }

    private void suchlaufDurchf\u00fchren() {
        DoInBackground.now((String)"Suche", (Runnable)this.neuLaden);
    }

    protected JPanel buildComponent() {
        JPanel result = new JPanel();
        result.setLayout((LayoutManager)new MigLayout("", "[]2px[]2px[]10px[]2px[]2px[]2px[]2px[]2px[]2px[]", ""));
        result.add((Component)new JLabel("Eingrenzen auf:"), "spanx 3");
        result.add((Component)new JLabel("Suchumfang:"), "spanx 7, wrap");
        ActionListener suchlaufDurchf\u00fchren = e -> this.suchlaufDurchf\u00fchren();
        this.suchtext.setColumns(15);
        this.suchtext.addActionListener(suchlaufDurchf\u00fchren);
        this.suchtext.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyChar() == '\u001b') {
                    ((JTextField)e.getSource()).setText("");
                    Arbeitsauftragseingrenzunganzeige.this.suchlaufDurchf\u00fchren();
                }
            }
        });
        result.add(this.suchtext);
        JButton suchlauf = new JButton("Suchen");
        suchlauf.addActionListener(suchlaufDurchf\u00fchren);
        result.add(suchlauf);
        JButton eingabeL\u00f6schen = new JButton("X");
        eingabeL\u00f6schen.addActionListener(e -> this.suchtext.setText(""));
        eingabeL\u00f6schen.addActionListener(suchlaufDurchf\u00fchren);
        result.add(eingabeL\u00f6schen);
        Vector<Eingrenzungsoption> optionen = new Vector<Eingrenzungsoption>();
        for (Eingrenzungsoption each : this.eingrenzungen) {
            optionen.add(each);
        }
        MultiComboBox auswahl = new MultiComboBox(new DefaultComboBoxModel(optionen), 40);
        auswahl.addActionListener(suchlaufDurchf\u00fchren);
        result.add((Component)auswahl);
        result.setBorder((Border)new RoundedBorder(Color.black, 10));
        return result;
    }

    @Override
    public Iterable<Arbeitsauftragdaten> grenzeEin(Iterable<Arbeitsauftragdaten> auftragsdaten) {
        String text = ((String)EDT.query(() -> this.suchtext.getText())).toLowerCase();
        return this.engine.grenzeEin(auftragsdaten, text, this.aktiveEingrenzungen());
    }

    protected Iterable<TextEingrenzung<Arbeitsauftragdaten>> aktiveEingrenzungen() {
        ArrayList<TextEingrenzung<Arbeitsauftragdaten>> result = new ArrayList<TextEingrenzung<Arbeitsauftragdaten>>();
        for (Eingrenzungsoption each : this.eingrenzungen) {
            each.verhalten().ifPresent(result::add);
        }
        return result;
    }

    protected static class Eingrenzungsoption
    extends MultiComboBox.CheckableItem {
        private final TextEingrenzung<Arbeitsauftragdaten> verhalten;

        public Eingrenzungsoption(TextEingrenzung<Arbeitsauftragdaten> verhalten) {
            super(verhalten.bezeichnung(), true);
            this.verhalten = verhalten;
        }

        public Optional<TextEingrenzung<Arbeitsauftragdaten>> verhalten() {
            boolean aktiv = (Boolean)EDT.query(() -> ((Eingrenzungsoption)this).isSelected());
            return aktiv ? Optional.of(this.verhalten) : Optional.empty();
        }
    }
}

