/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.gui.entities.arbeitsauftrag;

import com.schneide.base.datatypes.collections.iterable.FilteredIterable;
import com.schneide.base.datatypes.collections.iterable.IterableUtil;
import com.schneide.base.eventbus.News;
import com.schneide.base.gui.component.generic.UIComponent;
import com.schneide.base.gui.swing.EDT;
import com.schneide.werp.domain.produktion.Produktionsnummer;
import com.schneide.werp.domain.session.WerpSession;
import com.schneide.werp.produktion.domain.arbeitsauftrag.Arbeitsauftragdaten;
import com.schneide.werp.produktion.engine.dashboard.news.DashboarddatenAnzeigen;
import com.schneide.werp.produktion.gui.entities.arbeitsauftrag.Arbeitsauftragspalte;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import net.miginfocom.swing.MigLayout;

public class ArbeitsauftragDashboard
extends UIComponent<JPanel> {
    private final String \u00fcberschrift;
    private final Predicate<Arbeitsauftragdaten> boardfilter;
    private final Iterable<Arbeitsauftragspalte> spalten;
    private final JToggleButton anzeigeschaltfl\u00e4che;
    private Iterable<Arbeitsauftragdaten> zuletztAngezeigt;

    public ArbeitsauftragDashboard(String \u00fcberschrift, Iterable<Arbeitsauftragspalte> spalten, WerpSession session) {
        this.\u00fcberschrift = \u00fcberschrift;
        this.boardfilter = a -> true;
        this.spalten = spalten;
        this.anzeigeschaltfl\u00e4che = this.baueAnzeigeschaltfl\u00e4che(session);
        this.zuletztAngezeigt = Collections.emptyList();
    }

    private JToggleButton baueAnzeigeschaltfl\u00e4che(WerpSession session) {
        return (JToggleButton)EDT.query(() -> new JToggleButton("TODO"));
    }

    public JToggleButton anzeigeschaltfl\u00e4che() {
        return this.anzeigeschaltfl\u00e4che;
    }

    public void wirdAngezeigt(Consumer<News> sender, Iterable<Produktionsnummer> gew\u00e4hlteProduktionen) {
        EDT.perform(() -> this.anzeigeschaltfl\u00e4che.setSelected(true));
        sender.accept(new DashboarddatenAnzeigen(gew\u00e4hlteProduktionen));
    }

    public Iterable<Arbeitsauftragdaten> zuletztAngezeigt() {
        return this.zuletztAngezeigt;
    }

    public void wirdNichtMehrAngezeigt() {
        this.spalten.forEach(Arbeitsauftragspalte::leeren);
    }

    public void anzeigen(Iterable<Arbeitsauftragdaten> ungefiltert) {
        FilteredIterable anzeigen;
        this.getLogger().debug((Object)("Filtere " + IterableUtil.getSizeFor(ungefiltert) + " Arbeitsauftrag passend zum Dashboard"));
        this.zuletztAngezeigt = anzeigen = new FilteredIterable(ungefiltert, this.boardfilter);
        for (Arbeitsauftragspalte each : this.spalten) {
            each.anzeigen((Iterable<Arbeitsauftragdaten>)anzeigen);
        }
    }

    protected JPanel buildComponent() {
        EDT.always();
        JPanel body = new JPanel();
        int anzahlSpalten = IterableUtil.getSizeFor(this.spalten);
        String spaltendefinition = "[]20px".repeat(anzahlSpalten - 1) + "[fill, grow, push]";
        body.setLayout((LayoutManager)new MigLayout("ins 0", spaltendefinition, "[top]"));
        for (Arbeitsauftragspalte each : this.spalten) {
            body.add((Component)each.prepare(), "");
        }
        return body;
    }
}

