/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.gui.component;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class Verbindungspfeil {
    Arrow[] arrows = new Arrow[]{new LineArrow(), new CurvedArrow()};

    public static void main(String ... args) {
        final Verbindungspfeil arrows = new Verbindungspfeil();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame("Bevel Arrows");
                frame.add((Component)new JPanel(){
                    private static final long serialVersionUID = 2119704068738253085L;

                    @Override
                    public void paintComponent(Graphics g) {
                        arrows.draw((Graphics2D)g, this.getWidth(), this.getHeight());
                    }
                }, "Center");
                frame.setSize(800, 400);
                frame.setDefaultCloseOperation(3);
                frame.setVisible(true);
            }
        });
    }

    void draw(Graphics2D g, int width, int height) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, width, height);
        for (Arrow arrow : this.arrows) {
            g.setColor(Color.ORANGE);
            g.fillRect(350, 20, 20, 280);
            g.setStroke(new BasicStroke(20.0f, 0, 2));
            g.translate(0, 60);
            arrow.draw(g);
            g.setStroke(new BasicStroke(20.0f, 0, 0));
            g.translate(0, 100);
            arrow.draw(g);
            g.setStroke(new BasicStroke(20.0f, 0, 1));
            g.translate(0, 100);
            arrow.draw(g);
            g.translate(400, -260);
        }
    }

    public static void drawArrowLine(Graphics g, int x1, int y1, int x2, int y2, int d, int h) {
        double xm;
        int dx = x2 - x1;
        int dy = y2 - y1;
        double D = Math.sqrt(dx * dx + dy * dy);
        double xn = xm = D - (double)d;
        double ym = h;
        double yn = -h;
        double sin = (double)dy / D;
        double cos = (double)dx / D;
        double x = xm * cos - ym * sin + (double)x1;
        ym = xm * sin + ym * cos + (double)y1;
        xm = x;
        x = xn * cos - yn * sin + (double)x1;
        yn = xn * sin + yn * cos + (double)y1;
        xn = x;
        int[] xpoints = new int[]{x2, (int)xm, (int)xn};
        int[] ypoints = new int[]{y2, (int)ym, (int)yn};
        g.drawLine(x1, y1, x2, y2);
        g.fillPolygon(xpoints, ypoints, 3);
    }

    static interface Arrow {
        public void draw(Graphics2D var1);
    }

    static class LineArrow
    implements Arrow {
        LineArrow() {
        }

        @Override
        public void draw(Graphics2D g) {
            float arrowRatio = 0.5f;
            float arrowLength = 80.0f;
            BasicStroke stroke = (BasicStroke)g.getStroke();
            float endX = 350.0f;
            float veeX = switch (stroke.getLineJoin()) {
                case 2 -> 350.0f - stroke.getLineWidth() * 0.25f;
                default -> 350.0f - stroke.getLineWidth() * 0.5f / 0.5f;
                case 1 -> 350.0f - stroke.getLineWidth() * 0.5f;
            };
            Path2D.Float path = new Path2D.Float();
            path.moveTo(veeX - 80.0f, -40.0f);
            path.lineTo(veeX, 0.0f);
            path.lineTo(veeX - 80.0f, 40.0f);
            g.setColor(Color.BLUE);
            g.draw(path);
            g.setColor(Color.YELLOW);
            g.draw(new Line2D.Float(50.0f, 0.0f, veeX, 0.0f));
            g.setColor(Color.RED);
            g.draw(new Line2D.Float(50.0f, 0.0f, veeX - stroke.getLineWidth() * 0.25f, 0.0f));
        }
    }

    static class CurvedArrow
    implements Arrow {
        CurvedArrow() {
        }

        @Override
        public void draw(Graphics2D g) {
            float arrowRatio = 0.5f;
            float arrowLength = 80.0f;
            BasicStroke stroke = (BasicStroke)g.getStroke();
            float endX = 350.0f;
            float veeX = 350.0f - stroke.getLineWidth() * 0.5f / 0.5f;
            Path2D.Float path = new Path2D.Float();
            float waisting = 0.5f;
            float waistX = 310.0f;
            float waistY = 10.0f;
            float arrowWidth = 40.0f;
            path.moveTo(veeX - 80.0f, -40.0f);
            path.quadTo(310.0f, -10.0f, 350.0f, 0.0f);
            path.quadTo(310.0f, 10.0f, veeX - 80.0f, 40.0f);
            path.lineTo(veeX - 60.0f, 0.0f);
            path.lineTo(veeX - 80.0f, -40.0f);
            g.setColor(Color.BLUE);
            g.fill(path);
            g.setColor(Color.RED);
            g.draw(new Line2D.Float(50.0f, 0.0f, veeX - 40.0f, 0.0f));
        }
    }
}

