/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.gui.component;

import com.schneide.base.datatypes.collections.iterable.IterableUtil;
import com.schneide.base.gui.swing.EDT;
import com.schneide.werp.domain.erf\u00fcllung.produktion.Produktionsliste;
import com.schneide.werp.domain.erf\u00fcllung.produktion.Produktionslisteneintrag;
import com.schneide.werp.domain.oberfl\u00e4che.Oberfl\u00e4cheF\u00fcr;
import com.schneide.werp.domain.oberfl\u00e4che.Oberfl\u00e4chenbehandlungRepository;
import com.schneide.werp.domain.oberfl\u00e4che.Oberfl\u00e4chenspezifikation;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.swing.AbstractCellEditor;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;

public class Oberfl\u00e4chenauswahl
extends JPanel {
    private static final long serialVersionUID = 6081334848599516137L;
    private final Produktionsliste produktion;
    private final Oberfl\u00e4chenbehandlungRepository oberfl\u00e4chen;

    public Oberfl\u00e4chenauswahl(Produktionsliste produktion, Oberfl\u00e4chenbehandlungRepository oberfl\u00e4chen) {
        this.oberfl\u00e4chen = oberfl\u00e4chen;
        EDT.always();
        this.produktion = produktion;
        this.buildUI();
    }

    protected void buildUI() {
        this.setLayout(new BoxLayout(this, 2));
        Oberfl\u00e4chengrid grid = new Oberfl\u00e4chengrid(this.produktion.hierarchieAlsListe(), this.oberfl\u00e4chen);
        JTable tabelle = new JTable(grid);
        tabelle.setDefaultRenderer(Oberfl\u00e4cheF\u00fcr.class, new Oberfl\u00e4chenCellRenderer());
        tabelle.setDefaultEditor(Oberfl\u00e4cheF\u00fcr.class, new Oberfl\u00e4chenCellEditor(this.oberfl\u00e4chen));
        tabelle.setRowHeight(30);
        JScrollPane scrolling = new JScrollPane(tabelle);
        this.add(scrolling);
    }

    private static final class Oberfl\u00e4chengrid
    extends AbstractTableModel {
        private static final long serialVersionUID = -4825755299719708966L;
        private final List<Produktionslisteneintrag> eintr\u00e4ge;
        private final Map<Produktionslisteneintrag, Oberfl\u00e4cheF\u00fcr> aktuelleOberfl\u00e4chen;
        private final Oberfl\u00e4chenbehandlungRepository repository;
        private final List<String> spaltentitel = List.of("Artikel", "Oberfl\u00e4che");

        public Oberfl\u00e4chengrid(Iterable<Produktionslisteneintrag> eintr\u00e4ge, Oberfl\u00e4chenbehandlungRepository repository) {
            this.repository = repository;
            this.eintr\u00e4ge = IterableUtil.asList(eintr\u00e4ge);
            this.aktuelleOberfl\u00e4chen = new HashMap<Produktionslisteneintrag, Oberfl\u00e4cheF\u00fcr>();
            eintr\u00e4ge.forEach(ple -> this.aktuelleOberfl\u00e4chen.put((Produktionslisteneintrag)ple, new Oberfl\u00e4cheF\u00fcr(ple, this.repository)));
        }

        @Override
        public String getColumnName(int column) {
            return this.spaltentitel.get(column);
        }

        @Override
        public int getColumnCount() {
            return this.spaltentitel.size();
        }

        @Override
        public int getRowCount() {
            return this.eintr\u00e4ge.size();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return switch (columnIndex) {
                case 0 -> String.class;
                case 1 -> Oberfl\u00e4cheF\u00fcr.class;
                default -> throw new IllegalArgumentException("Unexpected value: " + columnIndex);
            };
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return switch (columnIndex) {
                case 0 -> this.eintragF\u00fcr(rowIndex).beschreibung();
                case 1 -> this.oberfl\u00e4cheF\u00fcr(rowIndex);
                default -> throw new IllegalArgumentException("Unexpected value: " + columnIndex);
            };
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return rowIndex >= 0 && this.oberfl\u00e4cheF\u00fcr(rowIndex).hat\u00c4nderbareOberfl\u00e4che();
        }

        private Produktionslisteneintrag eintragF\u00fcr(int row) {
            return this.eintr\u00e4ge.get(row);
        }

        private Oberfl\u00e4cheF\u00fcr oberfl\u00e4cheF\u00fcr(int row) {
            return this.aktuelleOberfl\u00e4chen.get(this.eintragF\u00fcr(row));
        }
    }

    private static class Oberfl\u00e4chenCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -1720600017367232453L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component result = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof Oberfl\u00e4cheF\u00fcr) {
                Oberfl\u00e4cheF\u00fcr oberfl\u00e4che = (Oberfl\u00e4cheF\u00fcr)value;
                ((JLabel)result).setText(oberfl\u00e4che.bezeichnung());
            }
            return result;
        }
    }

    private static class Oberfl\u00e4chenCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private static final long serialVersionUID = -2436071612363377349L;
        private final Oberfl\u00e4chenbehandlungRepository m\u00f6glichkeiten;
        private Oberfl\u00e4cheF\u00fcr aktuell;
        private Oberfl\u00e4chenspezifikation gew\u00e4hlt;
        private Optional<JTable> letzteTabelle;

        public Oberfl\u00e4chenCellEditor(Oberfl\u00e4chenbehandlungRepository m\u00f6glichkeiten) {
            this.m\u00f6glichkeiten = m\u00f6glichkeiten;
            this.aktuell = null;
            this.gew\u00e4hlt = null;
            this.letzteTabelle = Optional.empty();
        }

        @Override
        public Object getCellEditorValue() {
            return this.gew\u00e4hlt;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.letzteTabelle = Optional.ofNullable(table);
            if (value instanceof Oberfl\u00e4cheF\u00fcr) {
                this.aktuell = (Oberfl\u00e4cheF\u00fcr)value;
                this.gew\u00e4hlt = this.aktuell.aktuellGew\u00e4hlt().orElse(null);
            }
            JComboBox<Oberfl\u00e4chenspezifikation> auswahl = new JComboBox<Oberfl\u00e4chenspezifikation>();
            for (Oberfl\u00e4chenspezifikation each : this.m\u00f6glichkeiten.alleM\u00f6glichkeiten()) {
                auswahl.addItem(each);
            }
            auswahl.setMaximumRowCount(20);
            auswahl.setSelectedItem(this.gew\u00e4hlt);
            auswahl.addActionListener(this);
            if (isSelected) {
                auswahl.setBackground(table.getSelectionBackground());
            } else {
                auswahl.setBackground(table.getSelectionForeground());
            }
            return auswahl;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JComboBox auswahl = (JComboBox)event.getSource();
            this.gew\u00e4hlt = (Oberfl\u00e4chenspezifikation)auswahl.getSelectedItem();
            System.out.println("Gew\u00e4hlt: " + String.valueOf(this.gew\u00e4hlt));
            this.aktuell.setzeF\u00fcrGesamtenBaumAuf(Optional.ofNullable(this.gew\u00e4hlt));
            this.letzteTabelle.ifPresent(t -> {
                t.invalidate();
                t.repaint();
            });
        }
    }
}

