/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.engine.qrcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.schneide.base.text.buffer.DirectChunkBuffer;
import com.schneide.werp.domain.erf\u00fcllung.auftrag.Arbeitsauftrag;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Hashtable;
import java.util.List;

public class QRCodeF\u00fcr {
    public static QRCode auftrag(Arbeitsauftrag auftrag) {
        return QRCodeF\u00fcr.auftr\u00e4ge(List.of(auftrag));
    }

    public static QRCode auftr\u00e4ge(Iterable<Arbeitsauftrag> auftr\u00e4ge) {
        DirectChunkBuffer text = new DirectChunkBuffer((CharSequence)"\n");
        for (Arbeitsauftrag each : auftr\u00e4ge) {
            text.append((CharSequence)each.identifikation().alsText());
        }
        return QRCodeF\u00fcr.text(text.toString());
    }

    public static QRCode text(String text) {
        return gr\u00f6\u00dfe -> QRCodeF\u00fcr.createQRImage(text, gr\u00f6\u00dfe);
    }

    private static BufferedImage createQRImage(String qrCodeText, int size) throws IOException {
        Hashtable<EncodeHintType, Object> hintMap = new Hashtable<EncodeHintType, Object>();
        hintMap.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.L);
        hintMap.put(EncodeHintType.MARGIN, 0);
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        try {
            BitMatrix byteMatrix = qrCodeWriter.encode(qrCodeText, BarcodeFormat.QR_CODE, size, size, hintMap);
            int matrixWidth = byteMatrix.getWidth();
            BufferedImage image = new BufferedImage(matrixWidth, matrixWidth, 1);
            image.createGraphics();
            Graphics2D graphics = (Graphics2D)image.getGraphics();
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, 0, matrixWidth, matrixWidth);
            graphics.setColor(Color.BLACK);
            for (int i = 0; i < matrixWidth; ++i) {
                for (int j = 0; j < matrixWidth; ++j) {
                    if (!byteMatrix.get(i, j)) continue;
                    graphics.fillRect(i, j, 1, 1);
                }
            }
            return image;
        }
        catch (WriterException e) {
            throw new IOException("Fehler beim Erstellen des QR-Codes.", e);
        }
    }

    public static interface QRCode {
        public BufferedImage inGr\u00f6\u00dfe(int var1) throws IOException;
    }
}

