/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.engine;

import com.schneide.base.datatypes.collections.iterable.IterableUtil;
import com.schneide.base.logging.LoggedObject;
import com.schneide.werp.domain.erf\u00fcllung.auftrag.Arbeitsauftrag;
import com.schneide.werp.domain.erf\u00fcllung.auftrag.ArbeitsauftragRepository;
import com.schneide.werp.domain.erf\u00fcllung.zusammenfassung.Laufzettel;
import com.schneide.werp.domain.produktion.Produktionsnummer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

public class LaufzettelErstellen
extends LoggedObject {
    private final ArbeitsauftragRepository alleAuftr\u00e4ge;

    public LaufzettelErstellen(ArbeitsauftragRepository alleAuftr\u00e4ge) {
        this.alleAuftr\u00e4ge = alleAuftr\u00e4ge;
    }

    public Iterable<? extends Laufzettel> f\u00fcr(Produktionsnummer produktion, Iterable<Arbeitsauftrag> verlauf) {
        HashMap auftrag2Laufzettel = new HashMap();
        ArrayList<ModifizierbarerLaufzettel> result = new ArrayList<ModifizierbarerLaufzettel>();
        for (Arbeitsauftrag each : verlauf) {
            Optional<Object> aktuell = Optional.empty();
            if (each.istStartpunkt() || each.folgtAufFork(this.alleAuftr\u00e4ge) || each.istJoin()) {
                ModifizierbarerLaufzettel neu = new ModifizierbarerLaufzettel(produktion, result.size() + 1);
                neu.mitSchritt(each);
                IterableUtil.asStream((Iterable)each.vorarbeiten(this.alleAuftr\u00e4ge)).map(aa -> (ModifizierbarerLaufzettel)auftrag2Laufzettel.get(aa)).filter(ml -> ml != null).forEach(ml -> {
                    ml.alsNachfolger(neu);
                    neu.alsVorg\u00e4nger((ModifizierbarerLaufzettel)ml);
                });
                result.add(neu);
                aktuell = Optional.of(neu);
            } else {
                if (IterableUtil.getSizeFor((Iterable)each.vorarbeiten()) != 1) {
                    this.getLogger().warn((Object)("Ein Arbeitsauftrag in einer Kette hat mehr als eine Vorarbeit. Das verletzt die Dom\u00e4nenregeln: " + each.identifikation().alsText()));
                }
                IterableUtil.asStream((Iterable)each.vorarbeiten(this.alleAuftr\u00e4ge)).map(aa -> (ModifizierbarerLaufzettel)auftrag2Laufzettel.get(aa)).filter(ml -> ml != null).forEach(ml -> ml.mitSchritt(each));
                aktuell = IterableUtil.maybeFirst((Iterable)each.vorarbeiten(this.alleAuftr\u00e4ge)).map(auftrag2Laufzettel::get).filter(ml -> ml != null);
            }
            aktuell.ifPresent(ml -> auftrag2Laufzettel.put(each, ml));
        }
        return result;
    }

    private static class ModifizierbarerLaufzettel
    implements Laufzettel {
        private final String identifier;
        private final List<ModifizierbarerLaufzettel> vorg\u00e4nger;
        private final List<Arbeitsauftrag> schritte;
        private final List<ModifizierbarerLaufzettel> nachfolger;

        public ModifizierbarerLaufzettel(Produktionsnummer produktion, int index) {
            this(Laufzettel.identifierF\u00fcr((Produktionsnummer)produktion, (int)index));
        }

        protected ModifizierbarerLaufzettel(String identifier) {
            this.identifier = identifier;
            this.vorg\u00e4nger = new ArrayList<ModifizierbarerLaufzettel>();
            this.schritte = new ArrayList<Arbeitsauftrag>();
            this.nachfolger = new ArrayList<ModifizierbarerLaufzettel>();
        }

        public void alsVorg\u00e4nger(ModifizierbarerLaufzettel voran) {
            this.vorg\u00e4nger.add(voran);
        }

        public void alsNachfolger(ModifizierbarerLaufzettel danach) {
            this.nachfolger.add(danach);
        }

        public void mitSchritt(Arbeitsauftrag auftrag) {
            this.schritte.add(auftrag);
        }

        public String identifier() {
            return this.identifier;
        }

        public String titel() {
            return this.identifier();
        }

        public Iterable<? extends Laufzettel> nachfolger() {
            return List.copyOf(this.nachfolger);
        }

        public Iterable<Arbeitsauftrag> schritte() {
            return List.copyOf(this.schritte);
        }

        public Iterable<? extends Laufzettel> vorg\u00e4nger() {
            return this.vorg\u00e4nger;
        }
    }
}

