/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.engine;

import com.schneide.base.logging.LoggedObject;
import com.schneide.werp.domain.artikel.ArtikelRepository;
import com.schneide.werp.domain.erf\u00fcllung.auftrag.Arbeitsauftrag;
import com.schneide.werp.domain.erf\u00fcllung.auftrag.ArbeitsauftragIdentifikation;
import com.schneide.werp.domain.erf\u00fcllung.produktion.Produktionsliste;
import com.schneide.werp.domain.erf\u00fcllung.produktion.Produktionslisteneintrag;
import com.schneide.werp.domain.erf\u00fcllung.schritt.AngewendeterErf\u00fcllungsschritt;
import com.schneide.werp.domain.erf\u00fcllung.schritt.ArbeitsschrittRepository;
import com.schneide.werp.domain.erf\u00fcllung.weg.Erf\u00fcllungswegRepository;
import com.schneide.werp.domain.produktion.Produktionsnummer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

public class Arbeitsauftr\u00e4geErstellen
extends LoggedObject {
    private final ArtikelRepository artikel;
    private final Erf\u00fcllungswegRepository erf\u00fcllungswege;
    private final ArbeitsschrittRepository arbeitsschritte;

    public Arbeitsauftr\u00e4geErstellen(ArtikelRepository artikel, Erf\u00fcllungswegRepository erf\u00fcllungswege, ArbeitsschrittRepository arbeitsschritte) {
        this.artikel = artikel;
        this.erf\u00fcllungswege = erf\u00fcllungswege;
        this.arbeitsschritte = arbeitsschritte;
    }

    public Iterable<Arbeitsauftrag> f\u00fcr(Produktionsnummer projektname, Produktionsliste liste) {
        ArrayList<Arbeitsauftrag> result = new ArrayList<Arbeitsauftrag>();
        int index = 1;
        for (Produktionslisteneintrag each : liste.hauptbaugruppen()) {
            List<Arbeitsauftrag> neueAuftr\u00e4ge = this.f\u00fcrArtikel(projektname, each, index);
            result.addAll(neueAuftr\u00e4ge);
            index += neueAuftr\u00e4ge.size();
        }
        return result;
    }

    protected List<Arbeitsauftrag> f\u00fcrArtikel(Produktionsnummer projektname, Produktionslisteneintrag eintrag, int laufenderIndex) {
        ArrayList<Arbeitsauftrag> result = new ArrayList<Arbeitsauftrag>();
        HashMap<AngewendeterErf\u00fcllungsschritt, Arbeitsauftrag> bekannteVorigeAuftr\u00e4ge = new HashMap<AngewendeterErf\u00fcllungsschritt, Arbeitsauftrag>();
        int aktuellerIndex = laufenderIndex;
        Iterable kompletterWeg = eintrag.artikel().erf\u00fcllungswegAus(eintrag, this.artikel, this.erf\u00fcllungswege, this.arbeitsschritte);
        for (AngewendeterErf\u00fcllungsschritt aktuellerSchritt : kompletterWeg) {
            Arbeitsauftrag auftrag = new Arbeitsauftrag(new ArbeitsauftragIdentifikation(projektname, aktuellerIndex), aktuellerSchritt.artikel(), aktuellerSchritt.produktionskoordinate(), aktuellerSchritt.produktionsanzahl(), aktuellerSchritt.t\u00e4tigkeit(), aktuellerSchritt.kommentar());
            for (AngewendeterErf\u00fcllungsschritt voraussetzung : aktuellerSchritt.voraussetzungen()) {
                Optional<Arbeitsauftrag> maybeVorg\u00e4ngerauftrag = Optional.ofNullable((Arbeitsauftrag)bekannteVorigeAuftr\u00e4ge.get(voraussetzung));
                if (maybeVorg\u00e4ngerauftrag.isEmpty()) {
                    this.getLogger().warn((Object)("Nicht bekannter Vorg\u00e4ngerauftrag: " + String.valueOf(voraussetzung.t\u00e4tigkeit())));
                    continue;
                }
                Arbeitsauftrag vorg\u00e4ngerauftrag = maybeVorg\u00e4ngerauftrag.get();
                auftrag.h\u00e4ngtAbVon(vorg\u00e4ngerauftrag);
                vorg\u00e4ngerauftrag.vorarbeitVon(auftrag);
            }
            bekannteVorigeAuftr\u00e4ge.put(aktuellerSchritt, auftrag);
            ++aktuellerIndex;
            result.add(auftrag);
        }
        System.out.println("Erstelle Auftr\u00e4ge f\u00fcr " + eintrag.koordinate().alsText() + ": " + result.size());
        return result;
    }
}

