/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.convert;

import com.schneide.base.datatypes.conversion.Als;
import com.schneide.base.datatypes.optional.OptionalUtil;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.io.virtual.local.LocalVirtualFile;
import com.schneide.base.logging.LoggedObject;
import com.schneide.werp.domain.artikel.Artikel;
import com.schneide.werp.domain.artikel.Artikeleigenschaft;
import com.schneide.werp.domain.artikel.Artikelnummer;
import com.schneide.werp.domain.artikel.Artikelrevision;
import com.schneide.werp.domain.artikel.Baugruppe;
import com.schneide.werp.domain.artikel.Einzelteil;
import com.schneide.werp.domain.erf\u00fcllung.schritt.ArbeitsschrittRepository;
import com.schneide.werp.domain.format.excel.Exceldatei;
import com.schneide.werp.periphery.datenimport.lader.ExcelLader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class Konstruktionsst\u00fccklisteEinlesen
extends LoggedObject {
    private final ArbeitsschrittRepository arbeitsschritte;
    private final ExcelLader excel;

    public Konstruktionsst\u00fccklisteEinlesen(ArbeitsschrittRepository arbeitsschritte, ExcelLader excel) {
        this.arbeitsschritte = arbeitsschritte;
        this.excel = excel;
    }

    public Iterable<Artikel<?>> ausVerzeichnis(File verzeichnis) throws IOException {
        File[] st\u00fccklistendateien = verzeichnis.listFiles((dir, name) -> name.endsWith(".xls"));
        if (st\u00fccklistendateien == null) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList();
        for (File each : st\u00fccklistendateien) {
            this.ausDatei((VirtualFile)new LocalVirtualFile(each)).forEach(result::add);
        }
        return result;
    }

    public Iterable<Artikel<?>> ausDatei(VirtualFile datei) throws IOException {
        ArrayList result = new ArrayList();
        Iterable<Artikel<?>> eingeleseneArtikel = this.ausDatei(this.excel.ladenAus(datei));
        eingeleseneArtikel.forEach(result::add);
        return result;
    }

    public Iterable<Artikel<?>> ausDatei(Exceldatei spezifikation) throws IOException {
        this.getLogger().debug((Object)("Lese St\u00fccklistendatei: " + spezifikation.name()));
        Exceldatei.Exceltabelle tabelle = spezifikation.ersteTabelle();
        Optional baugruppennummer = tabelle.zellentext(1, 7);
        Optional revision = tabelle.zellentext(1, 11);
        Optional benennung_zeile1 = tabelle.zellentext(2, 3);
        Optional benennung_zeile2 = tabelle.zellentext(3, 3);
        Optional<String> benennung = benennung_zeile2.map(z2 -> String.join((CharSequence)" ", benennung_zeile1.orElse(""), z2));
        List<Optional<String>> notwendigeAngaben = List.of(baugruppennummer, revision, benennung);
        if (OptionalUtil.anyEmpty(notwendigeAngaben)) {
            throw new IOException("Nicht alle Angaben vorhanden!");
        }
        ArrayList result = new ArrayList();
        Baugruppe baugruppe = new Baugruppe(new Artikelnummer((String)baugruppennummer.get()), benennung.get(), Als.integer((String)((String)revision.get())).map(Artikelrevision::new).orElse(Artikelrevision.erste), "baugruppe-standard");
        Exceldatei st\u00fccklisteneintr\u00e4ge = spezifikation.mitKopfzeilen(6);
        Iterable zeilen = st\u00fccklisteneintr\u00e4ge.ersteTabelle().zeilenNachKopfzeilen();
        for (Exceldatei.Excelzeile each : zeilen) {
            Optional maybePosition = each.integerIn(0);
            Optional maybeAnzahl = each.integerIn(1);
            if (OptionalUtil.anyEmpty((Optional[])new Optional[]{maybePosition, maybeAnzahl})) break;
            Einzelteil teil = Konstruktionsst\u00fccklisteEinlesen.eintragF\u00fcr(each);
            baugruppe.f\u00fcgeInSt\u00fccklisteEin(((Integer)maybePosition.get()).intValue(), ((Integer)maybeAnzahl.get()).intValue(), (Artikel)teil);
            result.add((Artikel<?>)teil);
        }
        result.add((Artikel<?>)baugruppe);
        return result;
    }

    private static Iterable<String> nichtleereEintr\u00e4geAb(int ersteSpalte, Exceldatei.Excelzeile zeile) {
        String text;
        ArrayList<String> result = new ArrayList<String>();
        int spalte = ersteSpalte;
        while (!(text = zeile.stringIn(spalte)).isBlank()) {
            ++spalte;
            result.add(text);
        }
        return result;
    }

    private static Einzelteil eintragF\u00fcr(Exceldatei.Excelzeile zeile) {
        Einzelteil artikel = new Einzelteil(new Artikelnummer(zeile.stringIn("C")), zeile.stringIn("F"), zeile.integerIn("D").map(Artikelrevision::new).orElse(Artikelrevision.erste), zeile.stringIn("N"));
        artikel.mitEigenschaft(Artikeleigenschaft.Abmessung, zeile.stringIn("G"));
        artikel.mitEigenschaft(Artikeleigenschaft.Norm, zeile.stringIn("H"));
        artikel.mitEigenschaft(Artikeleigenschaft.Material, zeile.stringIn("I"));
        artikel.mitEigenschaft(Artikeleigenschaft.Masse, zeile.stringIn("K"));
        return artikel;
    }
}

