/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion.convert;

import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.text.StringUtil;
import com.schneide.base.text.transformation.Without;
import com.schneide.werp.domain.angebot.Angebotsdaten;
import com.schneide.werp.domain.format.csv.CSVDatei;
import com.schneide.werp.periphery.datenimport.lader.CSVLader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class AngebotsextraktEinlesen {
    private final CSVLader csv;

    public AngebotsextraktEinlesen(CSVLader csv) {
        this.csv = csv;
    }

    public Optional<Angebotsdaten> ausDatei(VirtualFile datei) throws IOException {
        return this.parse(this.csv.ladenAus(datei));
    }

    public Optional<Angebotsdaten> parse(CSVDatei inhalt) {
        Angebotdatenbuilder builder = new Angebotdatenbuilder();
        inhalt.zeilen().forEach(builder::consider);
        return builder.alsAngebot();
    }

    private static class Angebotdatenbuilder {
        private final List<Angabenparser<?>> parsers;
        private Positionenzeile positionen = new Positionenzeile();
        private Einzelangabe<Angebotsdaten.Angebotsversion> version;
        private Einzelangabe<Angebotsdaten.Angebotskunde> kunde;
        private Einzelangabe<Angebotsdaten.Projektbeschreibung> beschreibung;
        private Einzelangabe<Angebotsdaten.Angebotsnummer> nummer;
        private Einzelangabe<Angebotsdaten.Auftragnummer> auftrag;
        private Angabensammler kommentare;

        public Angebotdatenbuilder() {
            \u00dcberschriftenzeile \u00fcberschrift = new \u00dcberschriftenzeile("Pos.", this.positionen);
            this.auftrag = new Einzelangabe<Angebotsdaten.Auftragnummer>(this, "A-Nr."){

                @Override
                protected Optional<Angebotsdaten.Auftragnummer> wandleUm(String text) {
                    if (null == text) {
                        return Optional.empty();
                    }
                    return Optional.of(() -> text);
                }
            };
            this.nummer = new Einzelangabe<Angebotsdaten.Angebotsnummer>(this, "Angebotsnummer"){

                @Override
                protected Optional<Angebotsdaten.Angebotsnummer> wandleUm(String text) {
                    if (null == text) {
                        return Optional.empty();
                    }
                    return Optional.of(() -> text);
                }
            };
            this.version = new Einzelangabe<Angebotsdaten.Angebotsversion>(this, "Version"){

                @Override
                protected Optional<Angebotsdaten.Angebotsversion> wandleUm(String text) {
                    if (null == text) {
                        return Optional.empty();
                    }
                    int versionsnummer = Integer.parseInt(text);
                    return Optional.of(() -> versionsnummer);
                }
            };
            this.kunde = new Einzelangabe<Angebotsdaten.Angebotskunde>(this, "Kunde"){

                @Override
                protected Optional<Angebotsdaten.Angebotskunde> wandleUm(String text) {
                    if (null == text) {
                        return Optional.empty();
                    }
                    return Optional.of(() -> text);
                }
            };
            this.beschreibung = new Einzelangabe<Angebotsdaten.Projektbeschreibung>(this, "Projektbeschreibung", () -> ""){

                @Override
                protected Optional<Angebotsdaten.Projektbeschreibung> wandleUm(String text) {
                    if (null == text) {
                        return Optional.empty();
                    }
                    return Optional.of(() -> text);
                }
            };
            this.kommentare = new Angabensammler();
            this.parsers = List.of(this.positionen, \u00fcberschrift, this.auftrag, this.nummer, this.version, this.kunde, this.beschreibung, this.kommentare);
        }

        public void consider(CSVDatei.CSVZeile line) {
            for (Angabenparser<?> each : this.parsers) {
                if (each.verwende(line)) break;
            }
        }

        public Optional<Angebotsdaten> alsAngebot() {
            for (Angabenparser<?> each : this.parsers) {
                if (each.istAbrufbar()) continue;
                System.err.println("Nicht gesetzt: " + each.beschreibung());
                return Optional.empty();
            }
            final Iterable<String> gesammelt = this.kommentare.getGesammelt();
            Angebotsdaten result = new Angebotsdaten(){

                public Angebotsdaten.Auftragnummer auftrag() {
                    return (Angebotsdaten.Auftragnummer)auftrag.wert().get();
                }

                public Angebotsdaten.Angebotsnummer nummer() {
                    return (Angebotsdaten.Angebotsnummer)nummer.wert().get();
                }

                public Angebotsdaten.Angebotsversion version() {
                    return (Angebotsdaten.Angebotsversion)version.wert().get();
                }

                public Angebotsdaten.Angebotskunde kunde() {
                    return (Angebotsdaten.Angebotskunde)kunde.wert().get();
                }

                public Angebotsdaten.Projektbeschreibung beschreibung() {
                    return (Angebotsdaten.Projektbeschreibung)beschreibung.wert().get();
                }

                public Iterable<Angebotsdaten.Angebotsposition> positionen() {
                    return positionen.positionen();
                }

                public Iterable<String> weitereAngaben() {
                    return gesammelt;
                }
            };
            return Optional.of(result);
        }
    }

    private static class Positionenzeile
    extends Angabenparser<Iterable<Angebotsdaten.Angebotsposition>> {
        private final List<Angebotsdaten.Angebotsposition> positionen = new ArrayList<Angebotsdaten.Angebotsposition>();

        public Positionenzeile() {
            super(false);
        }

        public List<Angebotsdaten.Angebotsposition> positionen() {
            return this.positionen;
        }

        @Override
        public boolean istGesetzt() {
            return true;
        }

        @Override
        protected boolean extrahiereAus(CSVDatei.CSVZeile zeile) {
            final String position = Without.leading((String)"'", (String)zeile.stringIn(0).orElse(""));
            String anzahlText = zeile.stringIn(1).orElse("0");
            final String anpassung = zeile.stringIn(2).orElse("");
            final String nummer = zeile.stringIn(3).orElse("");
            final String beschreibung = zeile.stringIn(4).orElse("");
            final String knr = zeile.stringIn(5).orElse("");
            final int anzahl = Integer.valueOf(anzahlText);
            Angebotsdaten.Angebotsposition neuePosition = new Angebotsdaten.Angebotsposition(){

                public Angebotsdaten.Angebotspositionsnummer position() {
                    return () -> position;
                }

                public String kundennummer() {
                    return knr;
                }

                public String beschreibung() {
                    return beschreibung;
                }

                public boolean anpassung() {
                    return !StringUtil.isEmptyOrNull((String)anpassung);
                }

                public Angebotsdaten.Angebotsartikelnummer artikelnummer() {
                    return () -> nummer;
                }

                public int anzahl() {
                    return anzahl;
                }
            };
            this.positionen.add(neuePosition);
            return true;
        }

        @Override
        protected Optional<Iterable<Angebotsdaten.Angebotsposition>> wandleUm(String text) {
            return Optional.of(this.positionen);
        }

        @Override
        public String beschreibung() {
            return "Positionszeile";
        }

        @Override
        protected Optional<Iterable<Angebotsdaten.Angebotsposition>> fallback() {
            return Optional.empty();
        }
    }

    private static class \u00dcberschriftenzeile
    extends IdentifikationsbasierterAngabenparser<String> {
        private final Angabenparser<?> aktiviere;

        public \u00dcberschriftenzeile(String identifikation, Angabenparser<?> aktiviere) {
            super(identifikation, Optional.empty());
            this.aktiviere = aktiviere;
        }

        @Override
        protected boolean extrahiereAus(CSVDatei.CSVZeile zeile) {
            return this.ifIdentifikationMatches(zeile, rest -> {
                this.aktiviere.aktiviere();
                return this.setzeAuf(this.identifikation());
            });
        }

        @Override
        protected Optional<String> wandleUm(String text) {
            return Optional.ofNullable(text);
        }

        @Override
        public String beschreibung() {
            return "\u00dcberschrift beginnend mit " + this.identifikation();
        }
    }

    private static abstract class Einzelangabe<T>
    extends IdentifikationsbasierterAngabenparser<T> {
        public Einzelangabe(String identifikation, T fallback) {
            this(identifikation, Optional.ofNullable(fallback));
        }

        public Einzelangabe(String identifikation) {
            this(identifikation, Optional.empty());
        }

        public Einzelangabe(String identifikation, Optional<T> fallback) {
            super(identifikation + ":", fallback);
        }

        @Override
        protected boolean extrahiereAus(CSVDatei.CSVZeile line) {
            return this.ifIdentifikationMatches(line, spalten -> {
                Optional payload = spalten.stringIn(1);
                if (payload.isEmpty()) {
                    return false;
                }
                return this.setzeAuf((String)payload.get());
            });
        }

        @Override
        public String beschreibung() {
            return this.identifikation().replace(":", "");
        }
    }

    private static class Angabensammler
    extends IdentifikationsbasierterAngabenparser<String> {
        private final List<String> gesammelt = new ArrayList<String>();

        public Angabensammler() {
            super("", Optional.empty());
        }

        @Override
        protected boolean identifikationMatchesF\u00fcr(CSVDatei.CSVZeile zeile) {
            return true;
        }

        @Override
        public String beschreibung() {
            return "Kommentare";
        }

        @Override
        protected boolean extrahiereAus(CSVDatei.CSVZeile line) {
            Optional maybeTitel = line.stringIn(0);
            if (maybeTitel.isEmpty()) {
                return false;
            }
            Optional maybeWert = line.stringIn(1);
            String kommentarzeile = (String)maybeTitel.get() + maybeWert.map(s -> " " + s).orElse("");
            this.gesammelt.add(kommentarzeile);
            return true;
        }

        public Iterable<String> getGesammelt() {
            return this.gesammelt;
        }

        @Override
        public boolean istGesetzt() {
            return true;
        }

        @Override
        protected Optional<String> wandleUm(String text) {
            return Optional.ofNullable(text);
        }
    }

    private static abstract class IdentifikationsbasierterAngabenparser<T>
    extends Angabenparser<T> {
        private final String identifikation;
        private final Optional<T> fallback;

        public IdentifikationsbasierterAngabenparser(String identifikation, Optional<T> fallback) {
            this.identifikation = identifikation;
            this.fallback = fallback;
        }

        protected boolean ifIdentifikationMatches(CSVDatei.CSVZeile zeile, Function<CSVDatei.CSVZeile, Boolean> verarbeitung) {
            if (!this.identifikationMatchesF\u00fcr(zeile)) {
                return false;
            }
            return verarbeitung.apply(zeile);
        }

        protected boolean identifikationMatchesF\u00fcr(CSVDatei.CSVZeile zeile) {
            return zeile.stringIn(0).filter(text -> this.identifikation.equalsIgnoreCase((String)text)).isPresent();
        }

        protected String identifikation() {
            return this.identifikation;
        }

        @Override
        protected Optional<T> fallback() {
            return this.fallback;
        }
    }

    private static abstract class Angabenparser<T> {
        private Optional<T> wert = Optional.empty();
        private boolean istAktiviert;

        public Angabenparser() {
            this(true);
        }

        public Angabenparser(boolean istDirektAktiviert) {
            this.istAktiviert = istDirektAktiviert;
        }

        public boolean verwende(CSVDatei.CSVZeile line) {
            if (!this.istAktiviert) {
                return false;
            }
            return this.extrahiereAus(line);
        }

        public void aktiviere() {
            this.istAktiviert = true;
        }

        public boolean istGesetzt() {
            return this.wert.isPresent();
        }

        public boolean istAbrufbar() {
            return this.istGesetzt() || this.fallback().isPresent();
        }

        public Optional<T> wert() {
            return this.wert.or(this::fallback);
        }

        protected abstract Optional<T> fallback();

        protected abstract Optional<T> wandleUm(String var1);

        protected boolean setzeAuf(String text) {
            if (this.istGesetzt()) {
                System.err.println("Doppelter Wert!");
                return false;
            }
            Optional<T> maybeWert = this.wandleUm(text);
            this.wert = maybeWert;
            return maybeWert.isPresent();
        }

        protected abstract boolean extrahiereAus(CSVDatei.CSVZeile var1);

        public abstract String beschreibung();
    }
}

