/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion;

import com.schneide.base.application.ApplicationEngine;
import com.schneide.base.application.gui.GenericFrameVisualisationSpecification;
import com.schneide.base.application.gui.model.FrameVisualisationSpecification;
import com.schneide.base.application.gui.monitor.EventBusSubscribersWindow;
import com.schneide.base.application.interaction.MenuManager;
import com.schneide.base.application.module.ModuleEnvironment;
import com.schneide.base.application.module.ModulesConfiguration;
import com.schneide.base.application.module.creation.ConfigurableModuleCreationInformation;
import com.schneide.base.application.module.creation.ModuleSetup;
import com.schneide.base.application.module.state.ModuleStateCache;
import com.schneide.base.application.periphery.Periphery;
import com.schneide.base.application.process.context.collect.ContextObjectInstanceCollector;
import com.schneide.base.application.shutdown.ApplicationShutdown;
import com.schneide.base.application.shutdown.SystemExitApplicationShutdown;
import com.schneide.base.application.usermanagement.model.UserManager;
import com.schneide.base.configuration.relocation.RelocateConfiguration;
import com.schneide.base.datatypes.collections.iterable.IterableUtil;
import com.schneide.base.eventbus.News;
import com.schneide.base.eventbus.inspection.InspectableEventBus;
import com.schneide.base.gui.Resize;
import com.schneide.base.gui.icon.ExistingIcon;
import com.schneide.base.gui.icon.IconProvider;
import com.schneide.base.gui.swing.EDT;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.io.virtual.local.LocalVirtualFile;
import com.schneide.base.lifecycle.LifeCycle;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.properties.userLevel.SuffixProvider;
import com.schneide.werp.WerpApplicationEngine;
import com.schneide.werp.application.WerpAnwendungseigenschaften;
import com.schneide.werp.application.WerpApplicationBase;
import com.schneide.werp.application.configuration.filebased.ApplicationConfiguration;
import com.schneide.werp.configuration.erstausstattung.Erstausstattung;
import com.schneide.werp.configuration.installation.FileBasedInstallationConfiguration;
import com.schneide.werp.configuration.installation.InstallationConfiguration;
import com.schneide.werp.domain.artikel.Baugruppe;
import com.schneide.werp.domain.benutzer.plain.PlainWerpUser;
import com.schneide.werp.domain.erf\u00fcllung.schritt.ArbeitsschrittRepository;
import com.schneide.werp.domain.erf\u00fcllung.schritt.ErweiterbaresArbeitsschrittRepository;
import com.schneide.werp.domain.erf\u00fcllung.weg.BeschreibbaresErf\u00fcllungswegRepository;
import com.schneide.werp.domain.oberfl\u00e4che.Oberfl\u00e4chenbehandlungRepository;
import com.schneide.werp.domain.oberfl\u00e4che.filebased.ConfigFileBasedOberfl\u00e4chenbehandlungRepository;
import com.schneide.werp.domain.publishing.Report;
import com.schneide.werp.domain.report.Anwendungseigenschaften;
import com.schneide.werp.domain.session.WerpSession;
import com.schneide.werp.domain.session.WerpSessionHandler;
import com.schneide.werp.engine.periphery.Anwendungsumgebung;
import com.schneide.werp.engine.periphery.PeripherybasierteAnwendungsumgebung;
import com.schneide.werp.periphery.datenspeicherung.Datenspeicherung;
import com.schneide.werp.periphery.dokumenterstellung.Dokumenterstellung;
import com.schneide.werp.produktion.WerpApplicationModel;
import com.schneide.werp.produktion.domain.arbeitsschritt.filebased.ArbeitsschrittLogoAusDateiRepository;
import com.schneide.werp.produktion.domain.kommentar.VerzeichnisbasiertesKommentarRepository;
import com.schneide.werp.produktion.engine.arbeitsauftrag.Arbeitsauftragsdatenanzeige;
import com.schneide.werp.produktion.engine.arbeitsauftrag.aktion.ArbeitsauftragEditierenAktion;
import com.schneide.werp.produktion.engine.dashboard.Dashboardanzeige;
import com.schneide.werp.produktion.engine.dashboard.news.DashboardAnzeigen;
import com.schneide.werp.produktion.engine.qrcode.FileBasedQRCodeConfiguration;
import com.schneide.werp.produktion.gui.camera.QRCodeRecognition;
import com.schneide.werp.produktion.gui.entities.arbeitsauftrag.ArbeitsauftragDashboard;
import com.schneide.werp.produktion.gui.entities.arbeitsauftrag.Arbeitsauftragspalte;
import com.schneide.werp.produktion.gui.main.WerpMainFrame;
import com.schneide.werp.produktion.model.repository.BeschreibbaresArbeitsauftragRepository;
import com.schneide.werp.produktion.model.repository.filebased.verzeichnis.VerzeichnisbasiertesArbeitsauftragRepository;
import com.schneide.werp.produktion.model.repository.filebased.verzeichnis.VerzeichnisbasiertesArbeitsschrittRepository;
import com.schneide.werp.produktion.model.repository.filebased.verzeichnis.VerzeichnisbasiertesArtikelRepository;
import com.schneide.werp.produktion.model.repository.filebased.verzeichnis.VerzeichnisbasiertesErf\u00fcllungswegRepository;
import com.schneide.werp.produktion.model.repository.filebased.verzeichnis.VerzeichnisbasiertesProduktionsartikelRepository;
import com.schneide.werp.produktion.model.repository.filebased.verzeichnis.VerzeichnisbasiertesProjektRepository;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class WerpApplicationProduktion
extends WerpApplicationBase {
    private final Function<ModuleSetup, Iterable<ConfigurableModuleCreationInformation>> modules;
    private final ModuleStateCache moduleStates;
    private final Anwendungseigenschaften anwendung;
    private final ApplicationConfiguration configuration;
    private final Periphery periphery;
    private final WerpApplicationModel model;
    private final Dokumenterstellung shortcut;

    public WerpApplicationProduktion(ApplicationShutdown shutdown, Function<ModuleSetup, Iterable<ConfigurableModuleCreationInformation>> modules, Dokumenterstellung shortcut) {
        super(shutdown);
        this.modules = modules;
        this.shortcut = shortcut;
        this.configuration = ApplicationConfiguration.standard();
        this.periphery = new Periphery();
        this.moduleStates = new ModuleStateCache();
        this.anwendung = new WerpAnwendungseigenschaften(this.getApplicationInformation());
        this.model = new WerpApplicationModel(this.getApplicationBus(), this.zeitgeber(), this.anwendung);
    }

    public static WerpApplicationProduktion prepare(Function<ModuleSetup, Iterable<ConfigurableModuleCreationInformation>> modules, Dokumenterstellung shortcut) {
        RelocateConfiguration.silently();
        WerpApplicationProduktion application = new WerpApplicationProduktion((ApplicationShutdown)new SystemExitApplicationShutdown(), modules, shortcut);
        return application;
    }

    private Iterable<ArbeitsauftragDashboard> dashboardsF\u00fcr(WerpSession session) {
        return List.of(this.alleArbeitsauftr\u00e4ge(session));
    }

    private ArbeitsauftragDashboard alleArbeitsauftr\u00e4ge(WerpSession session) {
        Arbeitsauftragspalte alle = new Arbeitsauftragspalte("Alle Arbeitsauftr\u00e4ge", false, a -> true, session);
        ArbeitsauftragDashboard result = new ArbeitsauftragDashboard("Alle Arbeitsauftr\u00e4ge", List.of(alle), session);
        return result;
    }

    protected void start(WerpSession userSession) {
        GenericFrameVisualisationSpecification specification = new GenericFrameVisualisationSpecification(this.getApplication().getDescription(), this.getApplication().getIcon());
        Iterable<ArbeitsauftragDashboard> dashboards = this.dashboardsF\u00fcr(userSession);
        EDT.performBlocking(() -> this.lambda$start$1(userSession, (FrameVisualisationSpecification)specification, dashboards));
        this.getApplicationBus().publish((News)new DashboardAnzeigen((ArbeitsauftragDashboard)((Object)IterableUtil.elementAt((int)0, dashboards).get())));
        if (this.getSystemConfiguration().displayEventbusSubscribers() && ((PlainWerpUser)userSession.getUser()).getIsInternal()) {
            EventBusSubscribersWindow subscribers = new EventBusSubscribersWindow((InspectableEventBus)this.getApplicationBus());
            subscribers.show();
        }
    }

    protected Dokumenterstellung dokumentenerstellung() {
        Optional maybeReal = this.model.getUmgebung().dokumenterstellung();
        return maybeReal.orElseGet(() -> new Dokumenterstellung(this){

            public Dokumenterstellung to(OutputStream target) {
                return this;
            }

            public void given(Report report) throws IOException {
                throw new IOException("Keine Dokumentenerstellung konfiguriert!");
            }
        });
    }

    private void positionMainFrame(Resize.ResizeFrame resize) {
        resize.to(this.configuration.mainWindowSize());
        resize.at(this.configuration.mainWindowPosition());
        if (this.configuration.mainWindowMinimized()) {
            resize.minimize();
            return;
        }
        if (this.configuration.mainWindowMaximized()) {
            resize.maximize();
        }
    }

    protected SuffixProvider configurationSuffix() {
        return this.configuration.editionSuffix();
    }

    protected boolean istEchtbetrieb() {
        boolean result = this.configuration.istEchtbetrieb();
        this.getLogger().debug((Object)("Anwendung ist im Echtbetrieb: " + result));
        return result;
    }

    protected ApplicationEngine<WerpSession, PlainWerpUser> buildApplicationEngine() {
        WerpApplicationEngine result = new WerpApplicationEngine((WerpApplicationBase)this, this.getSystemConfiguration(), new WerpSessionHandler(this.zeitgeber()));
        result.start();
        return result;
    }

    protected void buildInitialEnvironment() {
        this.moduleStates.subscribeTo(this.getApplicationBus());
        PeripherybasierteAnwendungsumgebung umgebung = new PeripherybasierteAnwendungsumgebung(this.periphery, this.shortcut);
        this.model.setUmgebung((Anwendungsumgebung)umgebung);
    }

    protected Iterable<ConfigurableModuleCreationInformation> getModuleCreationInformations(ModulesConfiguration currentModulesConfiguration) {
        Iterable<ConfigurableModuleCreationInformation> result = this.modules.apply(new ModuleSetup(currentModulesConfiguration, this.environment(), this.periphery));
        for (ConfigurableModuleCreationInformation each : result) {
            each.addAdditionalFor(SuffixProvider.class, (Object)this.configurationSuffix());
        }
        return result;
    }

    private ModuleEnvironment environment() {
        return new ModuleEnvironment(this.getApplicationBus(), (IconProvider)new ExistingIcon(this.getIcon()), this.periphery.capabilityStorage());
    }

    protected boolean buildModuleDependentEnvironment() {
        Iterable nichtAufl\u00f6sbar;
        this.addDependent((LifeCycle)this.periphery);
        Datenspeicherung speicher = (Datenspeicherung)this.model.getUmgebung().ausUmgebung(Anwendungsumgebung::datenspeicherung, "Datenspeicherung");
        Erstausstattung.fallsNotwendigLaut((InstallationConfiguration)FileBasedInstallationConfiguration.standard(), (String)"Erstausstattung").ifPresent(ea -> ea.anlegenIn((VirtualFile)new LocalVirtualFile(".")));
        VerzeichnisbasiertesArbeitsschrittRepository arbeitsschritte = new VerzeichnisbasiertesArbeitsschrittRepository((VirtualFile)new LocalVirtualFile("data/arbeitsschritte"), speicher.arbeitsschritte());
        arbeitsschritte.wiedereinlesen();
        this.getLogger().info((Object)(arbeitsschritte.anzahl() + " Arbeitsschritte geladen."));
        this.model.setArbeitsschritte(arbeitsschritte);
        ArbeitsschrittLogoAusDateiRepository arbeitsschrittlogos = new ArbeitsschrittLogoAusDateiRepository((VirtualFile)new LocalVirtualFile("data/arbeitsschritt-logos"));
        arbeitsschrittlogos.starteMit(this.getApplicationBus());
        this.model.setArbeitsschrittlogos(arbeitsschrittlogos);
        VerzeichnisbasiertesErf\u00fcllungswegRepository erf\u00fcllungswege = new VerzeichnisbasiertesErf\u00fcllungswegRepository((VirtualFile)new LocalVirtualFile("data/erf\u00fcllungswege"), speicher.erf\u00fcllungswege(), (ArbeitsschrittRepository)arbeitsschritte);
        Baugruppe.erstelleStandardErf\u00fcllungswegIn((BeschreibbaresErf\u00fcllungswegRepository)erf\u00fcllungswege);
        erf\u00fcllungswege.wiedereinlesen();
        this.getLogger().info((Object)(erf\u00fcllungswege.anzahl() + " Erf\u00fcllungswege geladen."));
        this.model.setErf\u00fcllungswege(erf\u00fcllungswege);
        VerzeichnisbasiertesArtikelRepository artikel = new VerzeichnisbasiertesArtikelRepository((VirtualFile)new LocalVirtualFile("data/artikel"), speicher.artikel(), this.getApplicationBus());
        if (artikel.anzahl() == 0) {
            this.getLogger().info((Object)"Artikelcache ist leer, lese die Artikeldaten erneut ein.");
            artikel.wiedereinlesenMit((ArbeitsschrittRepository)arbeitsschritte);
        }
        if (IterableUtil.isEmpty((Iterable)(nichtAufl\u00f6sbar = artikel.alleReferenzenAufl\u00f6sen()))) {
            this.getLogger().info((Object)"Alle Artikelreferenzen in den St\u00fccklisten konnten aufgel\u00f6st werden.");
        } else {
            this.getLogger().warn((Object)"Es gibt Baugruppen mit nicht aufl\u00f6sbaren Artikelreferenzen in den St\u00fccklisten:");
            nichtAufl\u00f6sbar.forEach(ar -> this.getLogger().warn((Object)("- " + ar.artikelnummerMitRevisionAlsAnzeigetext())));
        }
        this.model.setArtikel(artikel);
        VerzeichnisbasiertesProjektRepository projekte = new VerzeichnisbasiertesProjektRepository((VirtualFile)new LocalVirtualFile("data/projekte"), speicher.projekte(), artikel);
        this.model.setProjekte(projekte);
        VerzeichnisbasiertesProduktionsartikelRepository produktionsartikel = new VerzeichnisbasiertesProduktionsartikelRepository((VirtualFile)new LocalVirtualFile("data/produktionsartikel"), speicher.produktionsartikel(), artikel);
        this.model.setProduktionsartikel(produktionsartikel);
        VerzeichnisbasiertesArbeitsauftragRepository arbeitsauftr\u00e4ge = new VerzeichnisbasiertesArbeitsauftragRepository((VirtualFile)new LocalVirtualFile("data/arbeitsauftr\u00e4ge"), speicher.arbeitsauftr\u00e4ge(), (ArbeitsschrittRepository)arbeitsschritte, produktionsartikel);
        this.model.setArbeitsauftr\u00e4ge(arbeitsauftr\u00e4ge);
        ConfigFileBasedOberfl\u00e4chenbehandlungRepository oberfl\u00e4chen = ConfigFileBasedOberfl\u00e4chenbehandlungRepository.standard();
        this.model.setOberfl\u00e4chen((Oberfl\u00e4chenbehandlungRepository)oberfl\u00e4chen);
        VerzeichnisbasiertesKommentarRepository kommentare = new VerzeichnisbasiertesKommentarRepository((VirtualFile)new LocalVirtualFile("data/kommentare"));
        this.model.setKommentare(kommentare);
        this.buildAktionen();
        if (FileBasedQRCodeConfiguration.standard().istErkennungAktiviert()) {
            QRCodeRecognition qrcodeSupport = new QRCodeRecognition();
            qrcodeSupport.lauscheAuf(this.getApplicationBus());
        }
        return true;
    }

    protected void buildAktionen() {
        ArrayList<LoggedObject> aktionen = new ArrayList<LoggedObject>();
        aktionen.add(new Arbeitsauftragsdatenanzeige(this.model.getArbeitsauftr\u00e4ge(), this.model.getArbeitsschrittlogos(), this.model.getZeitgeber()));
        aktionen.add(new ArbeitsauftragEditierenAktion(this.model.getArbeitsauftr\u00e4ge(), this.model.getKommentare()));
        aktionen.add(new Dashboardanzeige(this.model.getArbeitsauftr\u00e4ge()));
        aktionen.forEach(ea -> ea.lauscheAuf(this.getApplicationBus()));
    }

    protected Iterable<Object> getProcessContextObjects() {
        ContextObjectInstanceCollector objects = new ContextObjectInstanceCollector(new Object[0]);
        objects.addInstances(super.getProcessContextObjects());
        objects.addInstance((Object)this);
        objects.addInstance((Object)this.getSystemConfiguration());
        objects.addInstance((Object)this.getAboutInformation());
        objects.addInstance((Object)this.configuration);
        objects.addInstance((Object)this.anwendung);
        objects.addInstance((Object)this.getApplicationEngine());
        objects.addInstance((Object)this.getApplicationEngine().getUserManager());
        objects.addInstance((Object)this.periphery);
        objects.addGetterInstances((Object)this.model);
        return objects.getAsList();
    }

    protected boolean isLoginDialogShownInitially() {
        return !this.configuration.loginWindowMinimized();
    }

    protected void firstMinuteActions() {
    }

    protected void lastMinuteActions() {
    }

    protected void stopAdditional() {
    }

    private /* synthetic */ void lambda$start$1(WerpSession userSession, FrameVisualisationSpecification specification, Iterable dashboards) {
        WerpMainFrame mainFrame = new WerpMainFrame(userSession, specification, (MenuManager<WerpSession, PlainWerpUser>)this.getApplicationEngine().getMenuManager(), (UserManager<PlainWerpUser>)this.getApplicationEngine().getUserManager(), dashboards, this::dokumentenerstellung, () -> ((BeschreibbaresArbeitsauftragRepository)this.model.getArbeitsauftr\u00e4ge()).verf\u00fcgbareProduktionen(), () -> ((ErweiterbaresArbeitsschrittRepository)this.model.getArbeitsschritte()).alle());
        IterableUtil.first((Iterable)dashboards).ifPresent(mainFrame::f\u00fcrHauptbereich);
        this.positionMainFrame(mainFrame.resize());
        mainFrame.showFrameWithoutResizing();
    }
}

