/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.storage.types;

import org.eclipse.serializer.afs.types.WriteController;
import org.eclipse.serializer.util.logging.Logging;
import org.eclipse.store.storage.types.StorageWriteController;
import org.slf4j.Logger;

public class StorageWriteControllerReadOnlyMode
implements StorageWriteController {
    private static final Logger logger = Logging.getLogger(StorageWriteController.class);
    private WriteController writeController;
    private final WriteController defaultController;
    private final WriteController readOnlyController;

    public StorageWriteControllerReadOnlyMode(WriteController writeController) {
        this.defaultController = writeController;
        this.writeController = this.readOnlyController = WriteController.Disabled();
        logger.info("Created StorageWriteControllerReadOnlyMode with Storage read-only mode enabled: {}!", (Object)(this.writeController == this.readOnlyController ? 1 : 0));
    }

    public void setReadOnly(boolean readOnly) {
        this.writeController = readOnly ? this.readOnlyController : this.defaultController;
        logger.info("Read-only mode enabled: {}", (Object)(this.writeController == this.readOnlyController ? 1 : 0));
    }

    public boolean isReadOnly() {
        return this.writeController == this.readOnlyController;
    }

    public void validateIsWritable() {
        this.writeController.validateIsWritable();
    }

    public boolean isWritable() {
        return this.writeController.isWritable();
    }

    @Override
    public boolean isFileCleanupEnabled() {
        return this.writeController.isWritable();
    }

    @Override
    public boolean isBackupEnabled() {
        return this.defaultController.isWritable();
    }

    @Override
    public boolean isDeletionDirectoryEnabled() {
        return this.writeController.isWritable();
    }

    @Override
    public boolean isFileDeletionEnabled() {
        return this.writeController.isWritable();
    }
}

