/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.storage.types;

import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import org.eclipse.serializer.collections.ArrayView;
import org.eclipse.serializer.memory.XMemory;
import org.eclipse.serializer.util.X;
import org.eclipse.serializer.util.logging.Logging;
import org.eclipse.store.storage.exceptions.StorageException;
import org.eclipse.store.storage.types.StorageFileWriter;
import org.eclipse.store.storage.types.StorageLiveFileProvider;
import org.eclipse.store.storage.types.StorageLiveTransactionsFile;
import org.eclipse.store.storage.types.StorageTransactionsAnalysis;
import org.slf4j.Logger;

public interface StorageTransactionsFileCleaner {
    public void compactTransactionsFile(boolean var1);

    public static final class Default
    implements StorageTransactionsFileCleaner {
        private static final Logger logger = Logging.getLogger(StorageTransactionsFileCleaner.class);
        private final StorageLiveTransactionsFile storageLiveTransactionsFile;
        private final int channelIndex;
        private final long transactionFileSizeLimit;
        private final StorageFileWriter storageFileWriter;
        private final StorageLiveFileProvider fileProvider;
        private long lastStoreTimestamp;

        public Default(StorageLiveTransactionsFile fileTransactions, int channelIndex, long transactionFileSizeLimit, StorageLiveFileProvider fileProvider, StorageFileWriter storageFileWriter) {
            this.channelIndex = channelIndex;
            this.transactionFileSizeLimit = transactionFileSizeLimit;
            this.storageLiveTransactionsFile = fileTransactions;
            this.fileProvider = fileProvider;
            this.storageFileWriter = storageFileWriter;
        }

        @Override
        public void compactTransactionsFile(boolean checkSize) {
            if (checkSize && this.storageLiveTransactionsFile.size() > this.transactionFileSizeLimit) {
                logger.info("Transaction file {} size exceeds limit of {} bytes", (Object)this.storageLiveTransactionsFile.identifier(), (Object)this.transactionFileSizeLimit);
                this.compactTransactionsFileInternal();
            } else if (!checkSize) {
                this.compactTransactionsFileInternal();
            }
        }

        private void compactTransactionsFileInternal() {
            logger.info("Compacting transaction file {}", (Object)this.storageLiveTransactionsFile.identifier());
            LinkedHashMap<Long, FileTransactionInfo> transactions = this.collectEntries();
            this.lastStoreTimestamp = this.getLastStoreTimestamp(transactions);
            this.removeDeletedEntries(transactions);
            this.storageFileWriter.truncate(this.storageLiveTransactionsFile, 0L, this.fileProvider);
            this.writeTransactionLog(transactions);
        }

        private LinkedHashMap<Long, FileTransactionInfo> collectEntries() {
            Collector collector = new Collector();
            StorageTransactionsAnalysis.Logic.processInputFile(this.storageLiveTransactionsFile.file().tryUseReading(), collector);
            return collector.transactions();
        }

        private long getLastStoreTimestamp(LinkedHashMap<Long, FileTransactionInfo> transactions) {
            return transactions.values().stream().mapToLong(x -> x.storeTimeStamp).max().orElse(0L);
        }

        private void removeDeletedEntries(LinkedHashMap<Long, FileTransactionInfo> transactions) {
            transactions.entrySet().removeIf(e -> {
                logger.debug("channel {} file {} no more existing, removing all entries from transactions log ", (Object)this.channelIndex, e.getKey());
                return !this.fileProvider.provideDataFile(this.channelIndex, (Long)e.getKey()).exists();
            });
        }

        private void writeTransactionLog(LinkedHashMap<Long, FileTransactionInfo> transactions) {
            ByteBuffer entryBufferFileCreation = XMemory.allocateDirectNative((int)StorageTransactionsAnalysis.Logic.entryLengthFileCreation());
            ByteBuffer entryBufferStore = XMemory.allocateDirectNative((int)StorageTransactionsAnalysis.Logic.entryLengthStore());
            ByteBuffer entryBufferFileDeletion = XMemory.allocateDirectNative((int)StorageTransactionsAnalysis.Logic.entryLengthFileDeletion());
            ArrayView entryBufferWrapFileCreation = X.ArrayView((Object[])new ByteBuffer[]{entryBufferFileCreation});
            ArrayView entryBufferWrapStore = X.ArrayView((Object[])new ByteBuffer[]{entryBufferStore});
            ArrayView entryBufferWrapFileDeletion = X.ArrayView((Object[])new ByteBuffer[]{entryBufferFileDeletion});
            long entryBufferFileCreationAddress = XMemory.getDirectByteBufferAddress((ByteBuffer)entryBufferFileCreation);
            long entryBufferStoreAddress = XMemory.getDirectByteBufferAddress((ByteBuffer)entryBufferStore);
            long entryBufferFileDeletionAddress = XMemory.getDirectByteBufferAddress((ByteBuffer)entryBufferFileDeletion);
            StorageTransactionsAnalysis.Logic.initializeEntryFileCreation(entryBufferFileCreationAddress);
            StorageTransactionsAnalysis.Logic.initializeEntryStore(entryBufferStoreAddress);
            StorageTransactionsAnalysis.Logic.initializeEntryFileDeletion(entryBufferFileDeletionAddress);
            transactions.forEach((arg_0, arg_1) -> this.lambda$writeTransactionLog$2(entryBufferFileCreation, entryBufferFileCreationAddress, (Iterable)entryBufferWrapFileCreation, entryBufferStore, entryBufferStoreAddress, (Iterable)entryBufferWrapStore, entryBufferFileDeletion, entryBufferFileDeletionAddress, (Iterable)entryBufferWrapFileDeletion, arg_0, arg_1));
            XMemory.deallocateDirectByteBuffer((ByteBuffer)entryBufferFileCreation);
            XMemory.deallocateDirectByteBuffer((ByteBuffer)entryBufferStore);
            XMemory.deallocateDirectByteBuffer((ByteBuffer)entryBufferFileDeletion);
        }

        private /* synthetic */ void lambda$writeTransactionLog$2(ByteBuffer entryBufferFileCreation, long entryBufferFileCreationAddress, Iterable entryBufferWrapFileCreation, ByteBuffer entryBufferStore, long entryBufferStoreAddress, Iterable entryBufferWrapStore, ByteBuffer entryBufferFileDeletion, long entryBufferFileDeletionAddress, Iterable entryBufferWrapFileDeletion, Long k, FileTransactionInfo v) {
            entryBufferFileCreation.clear();
            StorageTransactionsAnalysis.Logic.setEntryFileCreation(entryBufferFileCreationAddress, v.creationFileLength, v.creationTimeStamp, k);
            this.storageFileWriter.writeTransactionEntryCreate(this.storageLiveTransactionsFile, entryBufferWrapFileCreation, null);
            if (v.storeTimeStamp > 0L) {
                entryBufferStore.clear();
                StorageTransactionsAnalysis.Logic.setEntryStore(entryBufferStoreAddress, v.storeFileLength, v.storeTimeStamp);
                this.storageFileWriter.writeTransactionEntryStore(this.storageLiveTransactionsFile, entryBufferWrapStore, null, 0L, v.storeFileLength);
            } else {
                entryBufferStore.clear();
                StorageTransactionsAnalysis.Logic.setEntryStore(entryBufferStoreAddress, v.storeFileLength, this.lastStoreTimestamp);
                this.storageFileWriter.writeTransactionEntryStore(this.storageLiveTransactionsFile, entryBufferWrapStore, null, 0L, v.storeFileLength);
            }
            if (v.deletionTimeStamp > 0L) {
                entryBufferFileDeletion.clear();
                StorageTransactionsAnalysis.Logic.setEntryFileDeletion(entryBufferFileDeletionAddress, v.deletionFileLength, v.deletionTimeStamp, k);
                this.storageFileWriter.writeTransactionEntryDelete(this.storageLiveTransactionsFile, entryBufferWrapFileDeletion, null);
            }
        }

        private static class Collector
        implements StorageTransactionsAnalysis.EntryIterator {
            private final LinkedHashMap<Long, FileTransactionInfo> transactions = new LinkedHashMap();
            private FileTransactionInfo currentTransactionInfo;

            public LinkedHashMap<Long, FileTransactionInfo> transactions() {
                return this.transactions;
            }

            @Override
            public boolean accept(long address, long availableEntryLength) {
                if (availableEntryLength < 0L) {
                    return true;
                }
                switch (StorageTransactionsAnalysis.Logic.getEntryType(address)) {
                    case 0: {
                        return this.handleEntryFileCreation(address, availableEntryLength);
                    }
                    case 1: {
                        return this.handleEntryStore(address, availableEntryLength);
                    }
                    case 2: {
                        return this.handleEntryTransfer(address, availableEntryLength);
                    }
                    case 3: {
                        return this.handleEntryFileTruncation(address, availableEntryLength);
                    }
                    case 4: {
                        return this.handleEntryFileDeletion(address, availableEntryLength);
                    }
                }
                throw new StorageException("Unknown transactions entry type: " + StorageTransactionsAnalysis.Logic.getEntryType(address));
            }

            private boolean handleEntryFileDeletion(long address, long availableEntryLength) {
                if (availableEntryLength < (long)StorageTransactionsAnalysis.Logic.LENGTH_FILE_DELETION) {
                    return false;
                }
                long fileNumber = StorageTransactionsAnalysis.Logic.getFileNumber(address);
                long fileLength = StorageTransactionsAnalysis.Logic.getFileLength(address);
                long timestamp = StorageTransactionsAnalysis.Logic.getEntryTimestamp(address);
                FileTransactionInfo info = this.transactions.get(fileNumber);
                if (info == null) {
                    throw new RuntimeException("no FileTransactionInfo for file found, file number: " + fileNumber);
                }
                info.setDeletion(fileLength, timestamp);
                return true;
            }

            private boolean handleEntryFileTruncation(long address, long availableEntryLength) {
                if (availableEntryLength < (long)StorageTransactionsAnalysis.Logic.LENGTH_FILE_TRUNCATION) {
                    return false;
                }
                long FileLength = StorageTransactionsAnalysis.Logic.getFileLength(address);
                this.currentTransactionInfo.setStore(FileLength, this.currentTransactionInfo.storeTimeStamp);
                return true;
            }

            private boolean handleEntryTransfer(long address, long availableEntryLength) {
                if (availableEntryLength < (long)StorageTransactionsAnalysis.Logic.LENGTH_TRANSFER) {
                    return false;
                }
                long FileLength = StorageTransactionsAnalysis.Logic.getFileLength(address);
                this.currentTransactionInfo.setStore(FileLength, this.currentTransactionInfo.storeTimeStamp);
                return true;
            }

            private boolean handleEntryStore(long address, long availableEntryLength) {
                if (availableEntryLength < (long)StorageTransactionsAnalysis.Logic.LENGTH_STORE) {
                    return false;
                }
                long FileLength = StorageTransactionsAnalysis.Logic.getFileLength(address);
                long timestamp = StorageTransactionsAnalysis.Logic.getEntryTimestamp(address);
                this.currentTransactionInfo.setStore(FileLength, timestamp);
                return true;
            }

            private boolean handleEntryFileCreation(long address, long availableEntryLength) {
                if (availableEntryLength < (long)StorageTransactionsAnalysis.Logic.LENGTH_FILE_CREATION) {
                    return false;
                }
                long fileNumber = StorageTransactionsAnalysis.Logic.getFileNumber(address);
                long fileLength = StorageTransactionsAnalysis.Logic.getFileLength(address);
                long timestamp = StorageTransactionsAnalysis.Logic.getEntryTimestamp(address);
                this.currentTransactionInfo = new FileTransactionInfo();
                this.currentTransactionInfo.setCreation(fileLength, timestamp);
                if (null != this.transactions.putIfAbsent(fileNumber, this.currentTransactionInfo)) {
                    throw new RuntimeException("duplicated creation entry!");
                }
                return true;
            }
        }

        private static class FileTransactionInfo {
            private long creationFileLength;
            private long creationTimeStamp;
            private long storeFileLength;
            private long storeTimeStamp;
            private long deletionFileLength;
            private long deletionTimeStamp;

            public void setCreation(long fileLength, long timestamp) {
                this.creationFileLength = fileLength;
                this.creationTimeStamp = timestamp;
            }

            public void setStore(long fileLength, long timestamp) {
                this.storeFileLength = fileLength;
                this.storeTimeStamp = timestamp;
            }

            public void setDeletion(long fileLength, long timestamp) {
                this.deletionFileLength = fileLength;
                this.deletionTimeStamp = timestamp;
            }
        }
    }
}

