/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.storage.types;

import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.store.storage.types.Storage;

public interface StorageTimestampProvider {
    public long currentNanoTimestamp();

    public long set(long var1);

    public static final class MonotonicCounter
    implements StorageTimestampProvider {
        private final AtomicLong lastValue = new AtomicLong();

        @Override
        public long currentNanoTimestamp() {
            return this.lastValue.incrementAndGet();
        }

        @Override
        public long set(long base) {
            return this.lastValue.updateAndGet(v -> base > v ? base : v);
        }
    }

    public static final class MonotonicTime
    implements StorageTimestampProvider {
        private long lastTimeNanos;

        @Override
        public synchronized long currentNanoTimestamp() {
            long currentTimeNanos = Storage.millisecondsToNanoseconds(System.currentTimeMillis());
            if (currentTimeNanos <= this.lastTimeNanos) {
                return ++this.lastTimeNanos;
            }
            this.lastTimeNanos = currentTimeNanos;
            return this.lastTimeNanos;
        }

        @Override
        public synchronized long set(long timeNs) {
            if (timeNs > this.lastTimeNanos) {
                this.lastTimeNanos = timeNs;
            }
            return this.lastTimeNanos;
        }
    }

    public static final class Default
    implements StorageTimestampProvider {
        private long lastTimeMillis;
        private long currentOffset;

        @Override
        public synchronized long currentNanoTimestamp() {
            long currentTimeMillis = System.currentTimeMillis();
            if (currentTimeMillis == this.lastTimeMillis) {
                return Storage.millisecondsToNanoseconds(currentTimeMillis) + ++this.currentOffset;
            }
            if (this.currentOffset != 0L) {
                this.currentOffset = 0L;
            }
            this.lastTimeMillis = currentTimeMillis;
            return Storage.millisecondsToNanoseconds(this.lastTimeMillis);
        }

        @Override
        public long set(long offset) {
            return 0L;
        }
    }
}

