/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.storage.types;

import org.eclipse.store.storage.exceptions.StorageException;
import org.eclipse.store.storage.types.StorageChannel;

public interface StorageTask {
    public void setNext(StorageTask var1);

    public StorageTask awaitNext(long var1) throws InterruptedException;

    public StorageTask next();

    public void processBy(StorageChannel var1) throws InterruptedException;

    public boolean isComplete();

    public void waitOnCompletion() throws InterruptedException;

    public boolean hasProblems();

    public Throwable[] problems();

    public Throwable problemForChannel(StorageChannel var1);

    public long timestamp();

    public static final class DummyTask
    extends Abstract {
        DummyTask() {
            super(0L);
        }

        @Override
        public final boolean isComplete() {
            return true;
        }

        @Override
        public final boolean hasProblems() {
            return false;
        }

        @Override
        public final Throwable[] problems() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Throwable problemForChannel(StorageChannel channel) {
            return this.problems()[channel.channelIndex()];
        }

        @Override
        public final void waitOnCompletion() throws InterruptedException {
        }

        @Override
        public void processBy(StorageChannel storageChannel) throws InterruptedException {
        }
    }

    public static abstract class Abstract
    implements StorageTask {
        private volatile StorageTask next;
        private final long timestamp;

        public Abstract(long timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final synchronized StorageTask awaitNext(long ms) throws InterruptedException {
            long waitTime;
            long targetTime = System.currentTimeMillis() + ms;
            while (this.next == null && (waitTime = targetTime - System.currentTimeMillis()) > 0L) {
                this.wait(waitTime);
            }
            return this.next;
        }

        @Override
        public final StorageTask next() {
            return this.next;
        }

        @Override
        public final void setNext(StorageTask next) {
            if (this.next != null) {
                throw new StorageException("next task already assigned: " + this + " -> " + this.next);
            }
            this.next = next;
        }

        @Override
        public final long timestamp() {
            return this.timestamp;
        }
    }
}

