/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.storage.types;

import java.text.DecimalFormat;
import java.util.Date;
import org.eclipse.serializer.chars.VarString;
import org.eclipse.serializer.collections.types.XGettingSequence;
import org.eclipse.serializer.collections.types.XGettingTable;
import org.eclipse.serializer.math.XMath;
import org.eclipse.serializer.util.X;
import org.eclipse.store.storage.types.StorageRawFileStatisticsItem;

public interface StorageRawFileStatistics
extends StorageRawFileStatisticsItem {
    public Date creationTime();

    public int channelCount();

    public XGettingTable<Integer, ? extends ChannelStatistics> channelStatistics();

    public static StorageRawFileStatistics New(Date creationTime, long fileCount, long liveDataLength, long totalDataLength, XGettingTable<Integer, ? extends ChannelStatistics> channelStatistics) {
        return new Default((Date)X.notNull((Object)creationTime), XMath.notNegative((long)fileCount), XMath.notNegative((long)liveDataLength), XMath.notNegative((long)totalDataLength), (XGettingTable<Integer, ? extends ChannelStatistics>)((XGettingTable)X.notNull(channelStatistics)));
    }

    public static interface FileStatistics
    extends StorageRawFileStatisticsItem {
        public long fileNumber();

        public String file();

        public static FileStatistics New(long fileNumber, String file, long liveDataLength, long totalDataLength) {
            return new Default(fileNumber, file, liveDataLength, totalDataLength);
        }

        public static final class Default
        extends StorageRawFileStatisticsItem.Abstract
        implements FileStatistics {
            final long fileNumber;
            final String file;

            Default(long fileNumber, String file, long liveDataLength, long totalDataLength) {
                super(1L, liveDataLength, totalDataLength);
                this.fileNumber = fileNumber;
                this.file = file;
            }

            @Override
            public final long fileNumber() {
                return this.fileNumber;
            }

            @Override
            public final String file() {
                return this.file;
            }
        }
    }

    public static interface ChannelStatistics
    extends StorageRawFileStatisticsItem {
        public int channelIndex();

        public XGettingSequence<? extends FileStatistics> files();

        public static ChannelStatistics New(int channelIndex, long fileCount, long liveDataLength, long totalDataLength, XGettingSequence<? extends FileStatistics> files) {
            return new Default(XMath.notNegative((int)channelIndex), XMath.notNegative((long)fileCount), XMath.notNegative((long)liveDataLength), XMath.notNegative((long)totalDataLength), (XGettingSequence<? extends FileStatistics>)((XGettingSequence)X.notNull(files)));
        }

        public static final class Default
        extends StorageRawFileStatisticsItem.Abstract
        implements ChannelStatistics {
            final int channelIndex;
            final XGettingSequence<? extends FileStatistics> files;

            Default(int channelIndex, long fileCount, long liveDataLength, long totalDataLength, XGettingSequence<? extends FileStatistics> files) {
                super(fileCount, liveDataLength, totalDataLength);
                this.channelIndex = channelIndex;
                this.files = files;
            }

            @Override
            public final int channelIndex() {
                return this.channelIndex;
            }

            @Override
            public final XGettingSequence<? extends FileStatistics> files() {
                return this.files;
            }
        }
    }

    public static final class Default
    extends StorageRawFileStatisticsItem.Abstract
    implements StorageRawFileStatistics {
        final Date creationTime;
        final XGettingTable<Integer, ? extends ChannelStatistics> channelStatistics;

        Default(Date creationTime, long fileCount, long liveDataLength, long totalDataLength, XGettingTable<Integer, ? extends ChannelStatistics> channelStatistics) {
            super(fileCount, liveDataLength, totalDataLength);
            this.creationTime = (Date)X.notNull((Object)creationTime);
            this.channelStatistics = (XGettingTable)X.notNull(channelStatistics);
        }

        @Override
        public final Date creationTime() {
            return this.creationTime;
        }

        @Override
        public final int channelCount() {
            return (int)this.channelStatistics.size();
        }

        @Override
        public final XGettingTable<Integer, ? extends ChannelStatistics> channelStatistics() {
            return this.channelStatistics;
        }

        private static double ratio(long value1, long value2) {
            return value2 == 0L ? 0.0 : (double)value1 / (double)value2;
        }

        public final VarString assembleString(VarString vs) {
            DecimalFormat ratioFormat = new DecimalFormat("0.00%");
            vs.add("Storage Statistics " + this.creationTime()).lf().tab().add("global file count:\t" + this.fileCount).lf().tab().add("global live data length:\t" + this.liveDataLength).lf().tab().add("global total data length:\t" + this.totalDataLength).lf().tab().add("global space efficiency:\t" + ratioFormat.format(Default.ratio(this.liveDataLength, this.totalDataLength))).lf().tab().add("channel count:\t" + this.channelCount()).lf();
            for (ChannelStatistics cs : this.channelStatistics.values()) {
                vs.lf().add("Channel " + cs.channelIndex()).lf().tab().add("file count:\t" + cs.fileCount()).lf().tab().add("live data length:\t" + cs.liveDataLength()).lf().tab().add("total data length:\t" + cs.totalDataLength()).lf().tab().add("space efficiency:\t" + ratioFormat.format(Default.ratio(cs.liveDataLength(), cs.totalDataLength()))).lf();
                for (FileStatistics fs : cs.files()) {
                    vs.tab().add(fs.file()).add(" (").add(fs.liveDataLength()).add(" / ").add(fs.totalDataLength()).add(", ").add(ratioFormat.format(Default.ratio(fs.liveDataLength(), fs.totalDataLength()))).add(")").lf();
                }
            }
            return vs;
        }

        public final String toString() {
            return this.assembleString(VarString.New()).toString();
        }
    }
}

